/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.djrapitops.plan.PlanBungee;
import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plan.identification.properties.RedisCheck;
import com.djrapitops.plan.identification.properties.RedisPlayersOnlineSupplier;
import java.util.function.IntSupplier;
import net.md_5.bungee.api.ProxyServer;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class BungeeSensor
implements ServerSensor<Object> {
    private final IntSupplier onlinePlayerCountSupplier;
    private final IntSupplier onlinePlayerCountBungee = () -> ((ProxyServer)plugin.getProxy()).getOnlineCount();

    @Inject
    public BungeeSensor(PlanBungee plugin) {
        this.onlinePlayerCountSupplier = RedisCheck.isClassAvailable() ? new RedisPlayersOnlineSupplier() : this.onlinePlayerCountBungee;
    }

    @Override
    public boolean supportsDirectTPS() {
        return false;
    }

    @Override
    public int getOnlinePlayerCount() {
        int count = this.onlinePlayerCountSupplier.getAsInt();
        return count != -1 ? count : this.onlinePlayerCountBungee.getAsInt();
    }
}

