/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import cn.nukkit.level.Level;
import com.djrapitops.plan.PlanNukkit;
import com.djrapitops.plan.gathering.ServerSensor;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NukkitSensor
implements ServerSensor<Level> {
    private final PlanNukkit plugin;

    @Inject
    public NukkitSensor(PlanNukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean supportsDirectTPS() {
        return true;
    }

    @Override
    public double getTPS() {
        return this.plugin.getServer().getTicksPerSecondAverage();
    }

    @Override
    public int getChunkCount(Level world) {
        return world.getChunks().size();
    }

    @Override
    public int getEntityCount(Level world) {
        return world.getEntities().length;
    }

    @Override
    public int getOnlinePlayerCount() {
        return this.plugin.getServer().getOnlinePlayers().size();
    }

    @Override
    public Iterable<Level> getWorlds() {
        return this.plugin.getServer().getLevels().values();
    }
}

