/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.events.ServerShutdownTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;

public abstract class ServerShutdownSave {
    protected final PluginLogger logger;
    private final DBSystem dbSystem;
    private final Locale locale;
    private final ErrorLogger errorLogger;
    private boolean shuttingDown = false;
    private boolean startedDatabase = false;

    public ServerShutdownSave(Locale locale, DBSystem dbSystem, PluginLogger logger, ErrorLogger errorLogger) {
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    protected abstract boolean checkServerShuttingDownStatus();

    public void serverIsKnownToBeShuttingDown() {
        this.shuttingDown = true;
    }

    public Optional<Future<?>> performSave() {
        if (!this.checkServerShuttingDownStatus() && !this.shuttingDown) {
            return Optional.empty();
        }
        Map<UUID, Session> activeSessions = SessionCache.getActiveSessions();
        if (activeSessions.isEmpty()) {
            return Optional.empty();
        }
        if (!this.shuttingDown) {
            this.logger.info(this.locale.getString(PluginLang.DISABLED_UNSAVED_SESSIONS));
        }
        return this.attemptSave(activeSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Future<?>> attemptSave(Map<UUID, Session> activeSessions) {
        try {
            this.prepareSessionsForStorage(activeSessions, System.currentTimeMillis());
            Optional<Future<?>> optional = Optional.of(this.saveActiveSessions(activeSessions));
            return optional;
        }
        catch (DBInitException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Find the sessions in the error file and save them manually or ignore. Report & delete the error file after.").related((Object)"Shutdown save failed to init database.").related((Object)activeSessions).build());
            Optional<Future<?>> optional = Optional.empty();
            return optional;
        }
        catch (IllegalStateException ignored) {
            Optional<Future<?>> optional = Optional.empty();
            return optional;
        }
        finally {
            this.closeDatabase(this.dbSystem.getDatabase());
        }
    }

    private Future<?> saveActiveSessions(Map<UUID, Session> activeSessions) {
        Database database = this.dbSystem.getDatabase();
        if (database.getState() == Database.State.CLOSED) {
            this.startedDatabase = true;
            database.init();
        }
        return this.saveSessions(activeSessions, database);
    }

    void prepareSessionsForStorage(Map<UUID, Session> activeSessions, long now) {
        for (Session session : activeSessions.values()) {
            Optional<Long> end = session.getValue(SessionKeys.END);
            if (end.isPresent()) continue;
            session.endSession(now);
        }
    }

    private Future<?> saveSessions(Map<UUID, Session> activeSessions, Database database) {
        return database.executeTransaction(new ServerShutdownTransaction(activeSessions.values()));
    }

    private void closeDatabase(Database database) {
        if (this.startedDatabase) {
            database.close();
        }
    }
}

