/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.djrapitops.plan.gathering.ServerShutdownSave;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ShutdownHook
extends Thread {
    private static ShutdownHook activated;
    private final ServerShutdownSave serverShutdownSave;

    @Inject
    public ShutdownHook(ServerShutdownSave serverShutdownSave) {
        this.serverShutdownSave = serverShutdownSave;
    }

    private static boolean isActivated() {
        return activated != null;
    }

    private static void activate(ShutdownHook hook) {
        activated = hook;
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private static void deactivate() {
        Runtime.getRuntime().removeShutdownHook(activated);
        activated = null;
    }

    public void register() {
        if (ShutdownHook.isActivated()) {
            ShutdownHook.deactivate();
        }
        ShutdownHook.activate(this);
    }

    @Override
    public void run() {
        this.serverShutdownSave.serverIsKnownToBeShuttingDown();
        this.serverShutdownSave.performSave().ifPresent(this::waitForSave);
    }

    private void waitForSave(Future<?> sessionsAreSavedFuture) {
        try {
            sessionsAreSavedFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Logger.getGlobal().log(Level.SEVERE, "Plan failed to save sessions on JVM shutdown.", e);
        }
    }
}

