/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.djrapitops.plan.PlanSponge;
import com.djrapitops.plan.gathering.ServerSensor;
import java.util.Iterator;
import org.spongepowered.api.world.World;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SpongeSensor
implements ServerSensor<World> {
    private final PlanSponge plugin;

    @Inject
    public SpongeSensor(PlanSponge plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean supportsDirectTPS() {
        return true;
    }

    @Override
    public int getOnlinePlayerCount() {
        return this.plugin.getGame().getServer().getOnlinePlayers().size();
    }

    @Override
    public double getTPS() {
        return this.plugin.getGame().getServer().getTicksPerSecond();
    }

    @Override
    public Iterable<World> getWorlds() {
        return this.plugin.getGame().getServer().getWorlds();
    }

    @Override
    public int getChunkCount(World world) {
        return -1;
    }

    private int getLaggyChunkCount(World world) {
        Iterator chunks = world.getLoadedChunks().iterator();
        int count = 0;
        while (chunks.hasNext()) {
            chunks.next();
            ++count;
        }
        return count;
    }

    @Override
    public int getEntityCount(World world) {
        return world.getEntities().size();
    }
}

