/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;

public class SystemUsage {
    private SystemUsage() {
    }

    public static long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        return (totalMemory - runtime.freeMemory()) / 1000000L;
    }

    public static double getAverageSystemLoad() {
        double averageUsage;
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean nativeOsBean = (OperatingSystemMXBean)osBean;
            averageUsage = nativeOsBean.getSystemCpuLoad();
        } else {
            int availableProcessors = osBean.getAvailableProcessors();
            averageUsage = osBean.getSystemLoadAverage() / (double)availableProcessors;
        }
        if (averageUsage < 0.0) {
            averageUsage = -1.0;
        }
        return averageUsage * 100.0;
    }

    public static long getFreeDiskSpace() {
        File file = new File(new File("").getAbsolutePath());
        return file.getUsableSpace() / 1000000L;
    }
}

