/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.afk;

import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AFKTracker {
    private final Set<UUID> usedAFKCommand;
    private final Map<UUID, Long> lastMovement;
    private final PlanConfig config;
    private Long afkThresholdMs;

    public AFKTracker(PlanConfig config) {
        this.config = config;
        this.usedAFKCommand = new HashSet<UUID>();
        this.lastMovement = new HashMap<UUID, Long>();
    }

    public long getAfkThreshold() {
        if (this.afkThresholdMs == null) {
            this.afkThresholdMs = this.config.get(TimeSettings.AFK_THRESHOLD);
        }
        return this.afkThresholdMs;
    }

    public void hasIgnorePermission(UUID uuid) {
        this.lastMovement.put(uuid, -1L);
    }

    public void usedAfkCommand(UUID uuid, long time) {
        this.usedAFKCommand.add(uuid);
        this.lastMovement.put(uuid, time - this.getAfkThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performedAction(UUID uuid, long time) {
        Long lastMoved = this.lastMovement.getOrDefault(uuid, time);
        if (lastMoved == -1L) {
            return;
        }
        this.lastMovement.put(uuid, time);
        try {
            if (time - lastMoved < this.getAfkThreshold()) {
                return;
            }
            long removeAfkCommandEffect = this.usedAFKCommand.contains(uuid) ? this.getAfkThreshold() : 0L;
            long timeAFK = time - lastMoved - removeAfkCommandEffect;
            SessionCache.getCachedSession(uuid).ifPresent(session -> session.addAFKTime(timeAFK));
        }
        finally {
            this.usedAFKCommand.remove(uuid);
        }
    }

    public void loggedOut(UUID uuid, long time) {
        this.performedAction(uuid, time);
        this.lastMovement.remove(uuid);
        this.usedAFKCommand.remove(uuid);
    }

    public boolean isAfk(UUID uuid) {
        long time = System.currentTimeMillis();
        Long lastMoved = this.lastMovement.get(uuid);
        if (lastMoved == null || lastMoved == -1L) {
            return false;
        }
        return time - lastMoved > this.getAfkThreshold();
    }
}

