/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.cache;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.gathering.cache.NicknameCache;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class CacheSystem
implements SubSystem {
    private final SessionCache sessionCache;
    private final NicknameCache nicknameCache;
    private final GeolocationCache geolocationCache;

    @Inject
    public CacheSystem(SessionCache sessionCache, NicknameCache nicknameCache, GeolocationCache geolocationCache) {
        this.sessionCache = sessionCache;
        this.nicknameCache = nicknameCache;
        this.geolocationCache = geolocationCache;
    }

    @Override
    public void enable() {
        this.nicknameCache.enable();
        this.geolocationCache.enable();
    }

    @Override
    public void disable() {
        this.geolocationCache.clearCache();
    }

    public NicknameCache getNicknameCache() {
        return this.nicknameCache;
    }

    public GeolocationCache getGeolocationCache() {
        return this.geolocationCache;
    }

    public SessionCache getSessionCache() {
        return this.sessionCache;
    }
}

