/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.cache;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.NicknameQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NicknameCache
implements SubSystem {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final ErrorLogger errorLogger;
    private final Map<UUID, String> displayNames;

    @Inject
    public NicknameCache(DBSystem dbSystem, ServerInfo serverInfo, ErrorLogger errorLogger) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.errorLogger = errorLogger;
        this.displayNames = new HashMap<UUID, String>();
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
        this.displayNames.clear();
    }

    public void removeDisplayName(UUID uuid) {
        this.displayNames.remove(uuid);
    }

    public Optional<String> getDisplayName(UUID uuid) {
        Optional<String> found;
        String cached = this.displayNames.get(uuid);
        if (cached == null && (found = this.getFromDatabase(uuid)).isPresent()) {
            this.displayNames.put(uuid, found.get());
            return found;
        }
        return Optional.empty();
    }

    private Optional<String> getFromDatabase(UUID uuid) {
        try {
            return this.dbSystem.getDatabase().query(NicknameQueries.fetchLastSeenNicknameOfPlayer(uuid, this.serverInfo.getServerUUID())).map(Nickname::getName);
        }
        catch (DBOpException e) {
            this.errorLogger.log(L.ERROR, e);
            return Optional.empty();
        }
    }
}

