/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.cache;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SessionCache {
    private static final Map<UUID, Session> ACTIVE_SESSIONS = new ConcurrentHashMap<UUID, Session>();

    @Inject
    public SessionCache() {
    }

    public static Map<UUID, Session> getActiveSessions() {
        SessionCache.refreshActiveSessionsState();
        return Collections.unmodifiableMap(new HashMap<UUID, Session>(ACTIVE_SESSIONS));
    }

    public static void clear() {
        ACTIVE_SESSIONS.clear();
    }

    public static void refreshActiveSessionsState() {
        ACTIVE_SESSIONS.values().forEach(Session::updateState);
    }

    public static Optional<Session> getCachedSession(UUID playerUUID) {
        Optional<Session> found = Optional.ofNullable(ACTIVE_SESSIONS.get(playerUUID));
        found.ifPresent(Session::updateState);
        return found;
    }

    public Optional<Session> cacheSession(UUID playerUUID, Session session) {
        Optional<Session> inProgress = Optional.empty();
        if (SessionCache.getCachedSession(playerUUID).isPresent()) {
            inProgress = this.endSession(playerUUID, session.getUnsafe(SessionKeys.START));
        }
        ACTIVE_SESSIONS.put(playerUUID, session);
        return inProgress;
    }

    public Optional<Session> endSession(UUID playerUUID, long time) {
        Session session = ACTIVE_SESSIONS.get(playerUUID);
        if (session == null || session.getUnsafe(SessionKeys.START) > time) {
            return Optional.empty();
        }
        ACTIVE_SESSIONS.remove(playerUUID);
        session.endSession(time);
        return Optional.of(session);
    }
}

