/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plugin.utilities.Verify;
import java.util.Objects;
import java.util.UUID;

public class BaseUser {
    private final UUID uuid;
    private final String name;
    private final long registered;
    private final int timesKicked;

    public BaseUser(UUID uuid, String name, long registered, int timesKicked) {
        Verify.nullCheck(uuid, () -> new IllegalArgumentException("'uuid' can not be null"));
        Verify.nullCheck(name, () -> new IllegalArgumentException("'name' can not be null"));
        this.uuid = uuid;
        this.name = name;
        this.registered = registered;
        this.timesKicked = timesKicked;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getRegistered() {
        return this.registered;
    }

    public int getTimesKicked() {
        return this.timesKicked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseUser)) {
            return false;
        }
        BaseUser baseUser = (BaseUser)o;
        return this.uuid.equals(baseUser.uuid) && this.name.equals(baseUser.name);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name);
    }

    public String toString() {
        return "BaseUser{" + this.uuid + ", '" + this.name + '\'' + ", +" + this.registered + ", kick:" + this.timesKicked + '}';
    }
}

