/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plan.gathering.domain.TimeKeeper;
import com.djrapitops.plugin.utilities.Verify;
import java.util.Map;
import java.util.Optional;

public class GMTimes
extends TimeKeeper {
    private static final String SURVIVAL = "SURVIVAL";
    private static final String CREATIVE = "CREATIVE";
    private static final String ADVENTURE = "ADVENTURE";
    private static final String SPECTATOR = "SPECTATOR";

    public GMTimes(Map<String, Long> times, String lastState, long lastStateChange) {
        super(times, lastState, lastStateChange);
    }

    public GMTimes(String lastState, long lastStateChange) {
        super(lastState, lastStateChange);
    }

    public GMTimes(String lastState) {
        super(lastState);
    }

    public GMTimes(Map<String, Long> times) {
        super(times);
    }

    public GMTimes() {
    }

    public static String[] getGMKeyArray() {
        return new String[]{SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR};
    }

    public static String magicNumberToGMName(int magicNumber) {
        switch (magicNumber) {
            case 0: {
                return SURVIVAL;
            }
            case 1: {
                return CREATIVE;
            }
            case 2: {
                return ADVENTURE;
            }
            case 3: {
                return SPECTATOR;
            }
        }
        return "UNKOWN";
    }

    public Optional<String> getMostUsedGameMode() {
        long max = 0L;
        String maxGM = null;
        for (Map.Entry entry : this.times.entrySet()) {
            if ((Long)entry.getValue() <= max) continue;
            max = (Long)entry.getValue();
            maxGM = (String)entry.getKey();
        }
        return Optional.ofNullable(maxGM);
    }

    public void setAllGMTimes(long ... times) {
        Verify.nullCheck(times);
        String[] gms = GMTimes.getGMKeyArray();
        int size = times.length;
        for (int i = 0; i < 4; ++i) {
            if (i >= size) {
                this.setTime(gms[i], 0L);
                continue;
            }
            this.setTime(gms[i], times[i]);
        }
    }

    public void resetTimes(long time) {
        this.resetState(SURVIVAL, time);
        this.resetState(CREATIVE);
        this.resetState(ADVENTURE);
        this.resetState(SPECTATOR);
    }

    @Override
    public String getState() {
        String state = super.getState();
        return state != null ? state : SURVIVAL;
    }
}

