/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plan.delivery.domain.DateObj;
import java.util.Objects;
import java.util.UUID;

public class Ping
extends DateObj<Double> {
    private final UUID serverUUID;
    private final double average;
    private final int min;
    private final int max;

    public Ping(long date, UUID serverUUID, int min, int max, double average) {
        super(date, average);
        this.serverUUID = serverUUID;
        this.average = average;
        this.min = min;
        this.max = max;
    }

    public UUID getServerUUID() {
        return this.serverUUID;
    }

    public double getAverage() {
        return this.average;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ping)) {
            return false;
        }
        Ping ping = (Ping)o;
        return Double.compare(ping.average, this.average) == 0 && this.min == ping.min && this.max == ping.max && Objects.equals(this.serverUUID, ping.serverUUID);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID, this.average, this.min, this.max);
    }

    public String toString() {
        return "Ping{serverUUID=" + this.serverUUID + ", average=" + this.average + ", min=" + this.min + ", max=" + this.max + '}';
    }
}

