/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plan.delivery.domain.DateHolder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class PlayerKill
implements DateHolder {
    private final UUID victim;
    private final String weapon;
    private final long date;
    private String victimName;
    private String killerName;

    public PlayerKill(UUID victim, String weapon, long date) {
        this.victim = victim;
        this.weapon = weapon;
        this.date = date;
    }

    public PlayerKill(UUID victim, String weapon, long date, String victimName) {
        this(victim, weapon, date);
        this.victimName = victimName;
    }

    public PlayerKill(UUID victim, String weapon, long date, String victimName, String killerName) {
        this(victim, weapon, date, victimName);
        this.killerName = killerName;
    }

    public UUID getVictim() {
        return this.victim;
    }

    public Optional<String> getVictimName() {
        return Optional.ofNullable(this.victimName);
    }

    public Optional<String> getKillerName() {
        return Optional.ofNullable(this.killerName);
    }

    @Override
    public long getDate() {
        return this.date;
    }

    public String getWeapon() {
        return this.weapon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerKill that = (PlayerKill)o;
        return this.date == that.date && Objects.equals(this.victim, that.victim) && Objects.equals(this.weapon, that.weapon);
    }

    public int hashCode() {
        return Objects.hash(this.victim, this.date, this.weapon);
    }

    public String toString() {
        return "PlayerKill{victim=" + this.victim + ", date=" + this.date + ", weapon='" + this.weapon + "'}";
    }

    public boolean isSelfKill() {
        return this.getVictimName().map(v -> v.equals(this.killerName)).orElse(false);
    }

    public boolean isNotSelfKill() {
        return !this.isSelfKill();
    }
}

