/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.domain.container.DynamicDataContainer;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.utilities.comparators.DateHolderRecentComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Session
extends DynamicDataContainer
implements DateHolder {
    private final long sessionStart;
    private WorldTimes worldTimes;
    private List<PlayerKill> playerKills;
    private int mobKills;
    private int deaths;
    private long afkTime;
    private boolean firstSession;

    public Session(UUID uuid, UUID serverUUID, long sessionStart, String world, String gm) {
        this.sessionStart = sessionStart;
        this.worldTimes = new WorldTimes(world, gm, sessionStart);
        this.playerKills = new ArrayList<PlayerKill>();
        this.mobKills = 0;
        this.deaths = 0;
        this.afkTime = 0L;
        this.putRawData(SessionKeys.UUID, uuid);
        this.putRawData(SessionKeys.SERVER_UUID, serverUUID);
        this.putSupplier(SessionKeys.START, this::getSessionStart);
        this.putSupplier(SessionKeys.WORLD_TIMES, this::getWorldTimes);
        this.putSupplier(SessionKeys.PLAYER_KILLS, this::getPlayerKills);
        this.putSupplier(SessionKeys.MOB_KILL_COUNT, this::getMobKills);
        this.putSupplier(SessionKeys.DEATH_COUNT, this::getDeaths);
        this.putSupplier(SessionKeys.AFK_TIME, this::getAfkTime);
        this.putSupplier(SessionKeys.PLAYER_KILL_COUNT, this.getUnsafe(SessionKeys.PLAYER_KILLS)::size);
        this.putSupplier(SessionKeys.LENGTH, () -> this.getValue(SessionKeys.END).orElse(System.currentTimeMillis()) - this.getUnsafe(SessionKeys.START));
        this.putSupplier(SessionKeys.ACTIVE_TIME, () -> this.getLength() - this.afkTime);
    }

    public Session(int id, UUID uuid, UUID serverUUID, long sessionStart, long sessionEnd, int mobKills, int deaths, long afkTime) {
        this.sessionStart = sessionStart;
        this.worldTimes = new WorldTimes();
        this.playerKills = new ArrayList<PlayerKill>();
        this.mobKills = mobKills;
        this.deaths = deaths;
        this.afkTime = afkTime;
        this.putRawData(SessionKeys.DB_ID, id);
        this.putRawData(SessionKeys.UUID, uuid);
        this.putRawData(SessionKeys.SERVER_UUID, serverUUID);
        this.putSupplier(SessionKeys.START, this::getSessionStart);
        this.putRawData(SessionKeys.END, sessionEnd);
        this.putSupplier(SessionKeys.WORLD_TIMES, this::getWorldTimes);
        this.putSupplier(SessionKeys.PLAYER_KILLS, this::getPlayerKills);
        this.putSupplier(SessionKeys.MOB_KILL_COUNT, this::getMobKills);
        this.putSupplier(SessionKeys.DEATH_COUNT, this::getDeaths);
        this.putSupplier(SessionKeys.AFK_TIME, this::getAfkTime);
        this.putSupplier(SessionKeys.FIRST_SESSION, this::isFirstSession);
        this.putSupplier(SessionKeys.PLAYER_KILL_COUNT, () -> this.getUnsafe(SessionKeys.PLAYER_KILLS).size());
        this.putSupplier(SessionKeys.LENGTH, () -> this.getValue(SessionKeys.END).orElse(System.currentTimeMillis()) - this.getUnsafe(SessionKeys.START));
        this.putSupplier(SessionKeys.ACTIVE_TIME, () -> this.getLength() - this.afkTime);
    }

    public void endSession(long endOfSession) {
        this.putRawData(SessionKeys.END, endOfSession);
        this.worldTimes.updateState(endOfSession);
    }

    public void changeState(String world, String gm, long time) {
        this.worldTimes.updateState(world, gm, time);
    }

    public void playerKilled(PlayerKill kill) {
        this.playerKills.add(kill);
    }

    public void mobKilled() {
        ++this.mobKills;
    }

    public void died() {
        ++this.deaths;
    }

    public long getLength() {
        return this.getValue(SessionKeys.LENGTH).orElse(0L);
    }

    @Override
    public long getDate() {
        return this.getUnsafe(SessionKeys.START);
    }

    public void setWorldTimes(WorldTimes worldTimes) {
        this.worldTimes = worldTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return this.getUnsafe(SessionKeys.START).equals(session.getUnsafe(SessionKeys.START)) && this.getValue(SessionKeys.END).orElse(-1L).equals(session.getValue(SessionKeys.END).orElse(-1L)) && this.mobKills == session.mobKills && this.deaths == session.deaths && Objects.equals(this.getPlayerKills(), session.getPlayerKills()) && Objects.equals(this.worldTimes, session.worldTimes);
    }

    public boolean isFetchedFromDB() {
        return this.supports(SessionKeys.DB_ID);
    }

    public void addAFKTime(long timeAFK) {
        this.afkTime += timeAFK;
    }

    public void setSessionID(int sessionID) {
        this.putRawData(SessionKeys.DB_ID, sessionID);
    }

    public void setAsFirstSessionIfMatches(Long registerDate) {
        if (registerDate != null && Math.abs(this.sessionStart - registerDate) < TimeUnit.SECONDS.toMillis(15L)) {
            this.firstSession = true;
        }
    }

    public boolean isFirstSession() {
        return this.firstSession;
    }

    public List<PlayerKill> getPlayerKills() {
        this.playerKills.sort(new DateHolderRecentComparator());
        return this.playerKills;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mobKills, this.deaths, this.afkTime);
    }

    private long getSessionStart() {
        return this.sessionStart;
    }

    private WorldTimes getWorldTimes() {
        return this.worldTimes;
    }

    public void setPlayerKills(List<PlayerKill> playerKills) {
        this.playerKills = playerKills;
    }

    private int getMobKills() {
        return this.mobKills;
    }

    private int getDeaths() {
        return this.deaths;
    }

    private long getAfkTime() {
        return this.afkTime;
    }

    public String toString() {
        return "Session{sessionStart=" + this.getUnsafe(SessionKeys.START) + ", sessionEnd=" + this.getValue(SessionKeys.END).orElse(null) + ", worldTimes=" + this.worldTimes + ", playerKills=" + this.playerKills + ", mobKills=" + this.mobKills + ", deaths=" + this.deaths + ", afkTime=" + this.afkTime + '}';
    }

    public void updateState() {
        this.worldTimes.updateState(System.currentTimeMillis());
    }
}

