/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plugin.utilities.Verify;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class TimeKeeper {
    protected Map<String, Long> times;
    protected String state;
    protected long lastStateChange;

    public TimeKeeper(Map<String, Long> times, String lastState, long lastStateChange) {
        this.times = times;
        this.state = lastState;
        this.lastStateChange = lastStateChange;
    }

    public TimeKeeper(String lastState, long lastStateChange) {
        this(new HashMap<String, Long>(), lastState, lastStateChange);
    }

    public TimeKeeper(String lastState) {
        this(new HashMap<String, Long>(), lastState, 0L);
    }

    public TimeKeeper(Map<String, Long> times) {
        this(times, null, 0L);
    }

    public TimeKeeper() {
        this(new HashMap<String, Long>());
    }

    public void setTime(String state, long time) {
        this.times.put(Verify.nullCheck(state), time);
    }

    public void renameState(String state, String renameTo) {
        Verify.nullCheck(state, renameTo);
        Long time = this.times.get(state);
        if (time != null) {
            this.times.put(renameTo, time);
            this.times.remove(state);
            if (state.equals(this.state)) {
                this.state = renameTo;
            }
        }
    }

    public void changeState(String newState, long ms) {
        Verify.nullCheck(newState);
        if (this.state == null) {
            this.state = newState;
        }
        Long currentTime = this.times.getOrDefault(this.state, 0L);
        long diff = ms - this.lastStateChange;
        this.times.put(this.state, currentTime + Math.abs(diff));
        this.state = newState;
        this.lastStateChange = ms;
    }

    protected void resetState(String state) {
        this.times.remove(Verify.nullCheck(state));
    }

    protected void resetState(String state, long time) {
        if (time > 0L) {
            this.times.put(Verify.nullCheck(state), time);
            this.lastStateChange = time;
            this.state = state;
        } else {
            this.resetState(state);
        }
    }

    public long getTime(String state) {
        return this.times.getOrDefault(state, 0L);
    }

    public void addTime(String state, long time) {
        this.times.put(state, this.times.getOrDefault(state, 0L) + time);
    }

    public long getTotal() {
        return this.times.values().stream().mapToLong(i -> i).sum();
    }

    public Map<String, Long> getTimes() {
        return this.times;
    }

    public void setTimes(Map<String, Long> times) {
        this.times = times;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public long getLastStateChange() {
        return this.lastStateChange;
    }

    public void setLastStateChange(long lastStateChange) {
        this.lastStateChange = lastStateChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeKeeper that = (TimeKeeper)o;
        return this.lastStateChange == that.lastStateChange && Objects.equals(this.times, that.times) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.times, this.state, this.lastStateChange);
    }

    public String toString() {
        return "TimeKeeper{times=" + this.times + ", state='" + this.state + "', lastStateChange=" + this.lastStateChange + '}';
    }
}

