/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import java.util.Objects;
import java.util.UUID;

public class UserInfo {
    private final UUID playerUUID;
    private final UUID serverUUID;
    private final long registered;
    private final boolean banned;
    private final boolean opped;

    public UserInfo(UUID playerUUID, UUID serverUUID, long registered, boolean opped, boolean banned) {
        this.playerUUID = playerUUID;
        this.serverUUID = serverUUID;
        this.registered = registered;
        this.opped = opped;
        this.banned = banned;
    }

    public UUID getPlayerUuid() {
        return this.playerUUID;
    }

    public UUID getServerUUID() {
        return this.serverUUID;
    }

    public long getRegistered() {
        return this.registered;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public boolean isOperator() {
        return this.opped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return this.registered == userInfo.registered && this.banned == userInfo.banned && this.opped == userInfo.opped && this.playerUUID.equals(userInfo.playerUUID) && this.serverUUID.equals(userInfo.serverUUID);
    }

    public int hashCode() {
        return Objects.hash(this.playerUUID, this.serverUUID, this.registered, this.banned, this.opped);
    }

    public String toString() {
        return "UserInfo{playerUUID=" + this.playerUUID + ", serverUUID=" + this.serverUUID + ", registered=" + this.registered + ", banned=" + this.banned + ", opped=" + this.opped + '}';
    }
}

