/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain;

import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.TimeKeeper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WorldTimes {
    private final Map<String, GMTimes> times;
    private String currentWorld;
    private String currentGamemode;

    public WorldTimes(String startingWorld, String startingGM, long time) {
        this.times = new HashMap<String, GMTimes>();
        this.currentWorld = startingWorld;
        this.currentGamemode = startingGM;
        this.addWorld(startingWorld, startingGM, time);
    }

    public WorldTimes(Map<String, GMTimes> times) {
        this.times = times;
    }

    public WorldTimes() {
        this(new HashMap<String, GMTimes>());
    }

    private void addWorld(String worldName, String gameMode, long changeTime) {
        if (worldName == null || gameMode == null) {
            return;
        }
        this.times.put(worldName, new GMTimes(gameMode, changeTime));
    }

    public void updateState(long changeTime) {
        this.updateState(this.currentWorld, this.currentGamemode, changeTime);
    }

    public void updateState(String worldName, String gameMode, long changeTime) {
        if (worldName == null || gameMode == null) {
            return;
        }
        GMTimes currentGMTimes = this.times.get(this.currentWorld);
        if (this.currentWorld.equals(worldName)) {
            currentGMTimes.changeState(gameMode, changeTime);
        } else {
            GMTimes newGMTimes = this.times.get(worldName);
            if (newGMTimes == null) {
                this.addWorld(worldName, gameMode, currentGMTimes.getLastStateChange());
            }
            currentGMTimes.changeState(this.currentGamemode, changeTime);
        }
        for (GMTimes gmTimes : this.times.values()) {
            gmTimes.setLastStateChange(changeTime);
        }
        this.currentWorld = worldName;
        this.currentGamemode = gameMode;
    }

    public long getWorldPlaytime(String world) {
        GMTimes gmTimes = this.times.get(world);
        return gmTimes != null ? gmTimes.getTotal() : 0L;
    }

    public long getTotal() {
        return this.times.values().stream().mapToLong(TimeKeeper::getTotal).sum();
    }

    public GMTimes getGMTimes(String world) {
        return this.times.getOrDefault(world, new GMTimes());
    }

    public Map<String, GMTimes> getWorldTimes() {
        return this.times;
    }

    public void setGMTimesForWorld(String world, GMTimes gmTimes) {
        this.times.put(world, gmTimes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldTimes that = (WorldTimes)o;
        return Objects.equals(this.times, that.times) && Objects.equals(this.currentWorld, that.currentWorld) && Objects.equals(this.currentGamemode, that.currentGamemode);
    }

    public int hashCode() {
        return Objects.hash(this.times, this.currentWorld, this.currentGamemode);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("WorldTimes (Current: " + this.currentWorld + "){\n");
        for (Map.Entry<String, GMTimes> entry : this.times.entrySet()) {
            GMTimes value = entry.getValue();
            b.append("World '").append(entry.getKey()).append("':\n").append("  Total: ").append(value.getTotal()).append("\n").append("  ").append(value.toString()).append("\n");
        }
        b.append("}");
        return b.toString();
    }

    public Optional<String> getCurrentWorld() {
        return Optional.ofNullable(this.currentWorld);
    }

    public void add(WorldTimes toAdd) {
        for (Map.Entry<String, GMTimes> entry : toAdd.getWorldTimes().entrySet()) {
            String worldName = entry.getKey();
            GMTimes gmTimes = entry.getValue();
            GMTimes currentGMTimes = this.getGMTimes(worldName);
            for (String gm : GMTimes.getGMKeyArray()) {
                currentGMTimes.addTime(gm, gmTimes.getTime(gm));
            }
            this.times.put(worldName, currentGMTimes);
        }
    }

    public boolean contains(String worldName) {
        return this.times.containsKey(worldName);
    }
}

