/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.domain.builders;

import com.djrapitops.plan.gathering.domain.TPS;

public class TPSBuilder {
    protected long date = 0L;
    protected double ticksPerSecond = -1.0;
    protected int players = -1;
    protected double cpuUsage = -1.0;
    protected long usedMemory = -1L;
    protected int entityCount = -1;
    protected int chunksLoaded = -1;
    protected long freeDiskSpace = -1L;

    private TPSBuilder() {
    }

    public static TPSBuilder get() {
        return new TPSBuilder();
    }

    public TPS toTPS() {
        return new TPS(this.date, this.ticksPerSecond, this.players, this.cpuUsage, this.usedMemory, this.entityCount, this.chunksLoaded, this.freeDiskSpace);
    }

    public TPSBuilder date(long date) {
        this.date = date;
        return this;
    }

    public TPSBuilder tps(double tps) {
        this.ticksPerSecond = tps;
        return this;
    }

    public TPSBuilder playersOnline(int online) {
        this.players = online;
        return this;
    }

    public TPSBuilder usedCPU(double cpu) {
        this.cpuUsage = cpu;
        return this;
    }

    public TPSBuilder usedMemory(long ram) {
        this.usedMemory = ram;
        return this;
    }

    public TPSBuilder entities(int count) {
        this.entityCount = count;
        return this;
    }

    public TPSBuilder chunksLoaded(int chunksLoaded) {
        this.chunksLoaded = chunksLoaded;
        return this;
    }

    public TPSBuilder freeDiskSpace(long freeDiskSpace) {
        this.freeDiskSpace = freeDiskSpace;
        return this;
    }
}

