/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.geolocation;

import com.djrapitops.plan.exceptions.PreparationException;
import com.djrapitops.plan.gathering.geolocation.Geolocator;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.storage.file.PlanFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import plan.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import plan.org.apache.commons.compress.utils.IOUtils;

@Singleton
public class GeoLite2Geolocator
implements Geolocator {
    private final PlanFiles files;
    private final PlanConfig config;
    private File geolocationDB;

    @Inject
    public GeoLite2Geolocator(PlanFiles files, PlanConfig config) {
        this.files = files;
        this.config = config;
    }

    @Override
    public void prepare() throws IOException {
        if (this.config.isFalse(DataGatheringSettings.ACCEPT_GEOLITE2_EULA)) {
            throw new PreparationException("Downloading GeoLite2 requires accepting GeoLite2 EULA - see '" + DataGatheringSettings.ACCEPT_GEOLITE2_EULA.getPath() + "' in the config.");
        }
        this.geolocationDB = this.files.getFileFromPluginFolder("GeoLite2-Country.mmdb");
        if (this.geolocationDB.exists()) {
            if (this.geolocationDB.lastModified() >= System.currentTimeMillis() - TimeUnit.DAYS.toMillis(7L)) {
                return;
            }
            Files.delete(this.geolocationDB.toPath());
        }
        this.downloadDatabase();
        Files.deleteIfExists(this.files.getFileFromPluginFolder("GeoIP.dat").toPath());
    }

    private void downloadDatabase() throws IOException {
        Properties properties = System.getProperties();
        properties.setProperty("sun.net.client.defaultConnectTimeout", Long.toString(TimeUnit.MINUTES.toMillis(1L)));
        properties.setProperty("sun.net.client.defaultReadTimeout", Long.toString(TimeUnit.MINUTES.toMillis(1L)));
        properties.setProperty("sun.net.http.retryPost", Boolean.toString(false));
        String downloadFrom = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-Country&license_key=DEyDUKfCwNbtc5eK&suffix=tar.gz";
        URL downloadSite = new URL(downloadFrom);
        try (InputStream in = downloadSite.openStream();
             GZIPInputStream gzipIn = new GZIPInputStream(in);
             TarArchiveInputStream tarIn = new TarArchiveInputStream(gzipIn);
             FileOutputStream fos = new FileOutputStream(this.geolocationDB.getAbsoluteFile());){
            this.findAndCopyFromTar(tarIn, fos);
        }
    }

    private void findAndCopyFromTar(TarArchiveInputStream tarIn, FileOutputStream fos) throws IOException {
        ArrayDeque<TarArchiveEntry> entries = new ArrayDeque<TarArchiveEntry>();
        entries.add(tarIn.getNextTarEntry());
        while (!entries.isEmpty()) {
            TarArchiveEntry entry = (TarArchiveEntry)entries.poll();
            if (entry.isDirectory()) {
                entries.addAll(Arrays.asList(entry.getDirectoryEntries()));
            }
            if (entry.getName().endsWith("GeoLite2-Country.mmdb")) {
                IOUtils.copy(tarIn, fos);
                break;
            }
            TarArchiveEntry next = tarIn.getNextTarEntry();
            if (next == null) continue;
            entries.add(next);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<String> getCountry(InetAddress inetAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

