/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.geolocation;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.PreparationException;
import com.djrapitops.plan.gathering.geolocation.GeoLite2Geolocator;
import com.djrapitops.plan.gathering.geolocation.Geolocator;
import com.djrapitops.plan.gathering.geolocation.IP2CGeolocator;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class GeolocationCache
implements SubSystem {
    private final Locale locale;
    private final PlanConfig config;
    private final PluginLogger logger;
    private final RunnableFactory runnableFactory;
    private final Cache<String, String> cache;
    private final Geolocator geoLite2Geolocator;
    private final Geolocator ip2cGeolocator;
    private Geolocator inUseGeolocator;

    @Inject
    public GeolocationCache(Locale locale, PlanConfig config, GeoLite2Geolocator geoLite2Geolocator, IP2CGeolocator ip2cGeolocator, PluginLogger logger, RunnableFactory runnableFactory) {
        this.locale = locale;
        this.config = config;
        this.geoLite2Geolocator = geoLite2Geolocator;
        this.ip2cGeolocator = ip2cGeolocator;
        this.logger = logger;
        this.runnableFactory = runnableFactory;
        this.cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @Override
    public void enable() {
        if (this.config.isTrue(DataGatheringSettings.GEOLOCATIONS)) {
            this.runnableFactory.create("Geolocator init", new AbsRunnable(){

                @Override
                public void run() {
                    if (GeolocationCache.this.inUseGeolocator == null) {
                        GeolocationCache.this.tryToPrepareGeoLite2();
                    }
                    if (GeolocationCache.this.inUseGeolocator == null) {
                        GeolocationCache.this.tryToPrepareIP2CGeolocator();
                    }
                    if (GeolocationCache.this.inUseGeolocator == null) {
                        GeolocationCache.this.logger.error("Failed to enable geolocation.");
                    }
                }
            }).runTaskAsynchronously();
        } else {
            this.logger.info(this.locale.getString(PluginLang.ENABLE_NOTIFY_GEOLOCATIONS_DISABLED));
        }
    }

    public boolean canGeolocate() {
        return this.inUseGeolocator != null;
    }

    private void tryToPrepareIP2CGeolocator() {
        this.logger.warn("Fallback: using IP2C for Geolocation (doesn't support IPv6).");
        try {
            this.ip2cGeolocator.prepare();
            this.inUseGeolocator = this.ip2cGeolocator;
        }
        catch (PreparationException e) {
            this.logger.warn(e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("Fallback to IP2C failed: " + e.getMessage());
        }
    }

    public void tryToPrepareGeoLite2() {
        try {
            this.geoLite2Geolocator.prepare();
            this.inUseGeolocator = this.geoLite2Geolocator;
        }
        catch (PreparationException e) {
            this.logger.info(e.getMessage());
        }
        catch (UnknownHostException e) {
            this.logger.error(this.locale.getString(PluginLang.ENABLE_NOTIFY_GEOLOCATIONS_INTERNET_REQUIRED));
        }
        catch (IOException e) {
            this.logger.error(this.locale.getString(PluginLang.ENABLE_FAIL_GEODB_WRITE) + ": " + e.getMessage());
        }
    }

    public String getCountry(String ipAddress) {
        return this.cache.get(ipAddress, this::getUnCachedCountry);
    }

    private String getUnCachedCountry(String ipAddress) {
        if (this.inUseGeolocator == null) {
            return null;
        }
        return this.inUseGeolocator.getCountry(ipAddress).orElse("Not Found");
    }

    boolean isCached(String ipAddress) {
        return this.cache.getIfPresent(ipAddress) != null;
    }

    @Override
    public void disable() {
        this.clearCache();
    }

    public void clearCache() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }
}

