/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.gathering.importing.importers.Importer;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ImportSystem
implements SubSystem {
    protected final Map<String, Importer> importers = new HashMap<String, Importer>();

    @Override
    public void enable() {
        this.registerImporters();
    }

    abstract void registerImporters();

    public void registerImporter(Importer importer) {
        Verify.nullCheck(importer, () -> new IllegalArgumentException("Importer cannot be null"));
        this.importers.put(importer.getName(), importer);
    }

    public Optional<Importer> getImporter(String name) {
        return Optional.ofNullable(this.importers.get(name));
    }

    public List<String> getImporterNames() {
        ArrayList<String> names = new ArrayList<String>(this.importers.keySet());
        Collections.sort(names);
        return names;
    }

    @Override
    public void disable() {
        this.importers.clear();
    }
}

