/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing.data;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.gathering.importing.data.UserImportData;
import com.djrapitops.plugin.api.utility.UUIDFetcher;
import com.djrapitops.plugin.benchmarking.Timings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;

public class BukkitUserImportRefiner {
    private final Plan plugin;
    private final Timings timings;
    private final boolean onlineMode;
    private final List<UserImportData> importers = new ArrayList<UserImportData>();
    private final Map<UserImportData, String> missingUUIDs = new HashMap<UserImportData, String>();
    private final Map<UserImportData, String> missingNames = new HashMap<UserImportData, String>();
    private final Map<UserImportData, String> foundUUIDs = new HashMap<UserImportData, String>();
    private final Map<UserImportData, String> foundNames = new HashMap<UserImportData, String>();

    public BukkitUserImportRefiner(Plan plugin, List<UserImportData> importers) {
        this.plugin = plugin;
        this.timings = plugin.getTimings();
        this.importers.addAll(importers);
        this.onlineMode = plugin.getServer().getOnlineMode();
    }

    public List<UserImportData> refineData() {
        String benchmarkName = "Refining UserImportData";
        this.timings.start(benchmarkName);
        this.processMissingIdentifiers();
        this.timings.end("Importing", benchmarkName);
        return this.importers;
    }

    private void processMissingIdentifiers() {
        String benchmarkName = "Processing missing identifiers";
        this.timings.start(benchmarkName);
        ArrayList invalidData = new ArrayList();
        this.importers.parallelStream().forEach(importer -> {
            boolean uuidNull;
            String name = importer.getName();
            UUID uuid = importer.getUuid();
            boolean nameNull = name == null;
            boolean bl = uuidNull = uuid == null;
            if (nameNull && uuidNull) {
                invalidData.add(importer);
            } else if (nameNull) {
                this.missingNames.put((UserImportData)importer, uuid.toString());
            } else if (uuidNull) {
                this.missingUUIDs.put((UserImportData)importer, name);
            }
        });
        this.importers.removeAll(invalidData);
        this.processMissingUUIDs();
        this.processMissingNames();
        this.timings.end("Importing", benchmarkName);
    }

    private void processMissingUUIDs() {
        String benchmarkName = "Processing missing UUIDs";
        this.timings.start(benchmarkName);
        if (this.onlineMode) {
            this.addMissingUUIDsOverFetcher();
            this.addMissingUUIDsOverOfflinePlayer();
        } else {
            this.addMissingUUIDsOverOfflinePlayer();
            this.addMissingUUIDsOverFetcher();
        }
        this.foundUUIDs.entrySet().parallelStream().forEach(entry -> {
            UserImportData userImportData = (UserImportData)entry.getKey();
            UUID uuid = UUID.fromString((String)entry.getValue());
            userImportData.setUuid(uuid);
        });
        this.importers.removeAll(this.missingUUIDs.keySet());
        this.timings.end("Importing", benchmarkName);
    }

    private void addMissingUUIDsOverFetcher() {
        Map<String, String> result;
        UUIDFetcher uuidFetcher = new UUIDFetcher(new ArrayList<String>(this.missingUUIDs.values()));
        try {
            result = uuidFetcher.call().entrySet().parallelStream().collect(Collectors.toMap(entry -> ((UUID)entry.getValue()).toString(), Map.Entry::getKey));
        }
        catch (Exception e) {
            return;
        }
        this.addFoundUUIDs(result);
    }

    private void addMissingUUIDsOverOfflinePlayer() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : this.missingUUIDs.values()) {
            String uuid = this.getUuidByOfflinePlayer(name);
            if (uuid == null) continue;
            result.put(name, uuid);
        }
        this.addFoundUUIDs(result);
    }

    private void addFoundUUIDs(Map<String, String> foundUUIDs) {
        ArrayList found = new ArrayList();
        this.missingUUIDs.entrySet().parallelStream().forEach(entry -> {
            UserImportData importer = (UserImportData)entry.getKey();
            String name = (String)entry.getValue();
            String uuid = (String)foundUUIDs.get(name);
            this.foundUUIDs.put(importer, uuid);
            found.add(importer);
        });
        this.missingUUIDs.keySet().removeAll(found);
    }

    private String getUuidByOfflinePlayer(String name) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(name);
        if (!player.hasPlayedBefore()) {
            return null;
        }
        return player.getUniqueId().toString();
    }

    private void processMissingNames() {
        String benchmarkNames = "Processing missing names";
        this.timings.start(benchmarkNames);
        this.findMissingNames();
        this.foundNames.entrySet().parallelStream().forEach(entry -> ((UserImportData)entry.getKey()).setName((String)entry.getValue()));
        this.importers.removeAll(this.missingNames.keySet());
        this.timings.end("Importing", benchmarkNames);
    }

    private void findMissingNames() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.missingNames.values().parallelStream().forEach(uuid -> {
            String name = this.getNameByOfflinePlayer((String)uuid);
            result.put((String)uuid, name);
        });
        this.addFoundNames(result);
    }

    private void addFoundNames(Map<String, String> foundNames) {
        ArrayList found = new ArrayList();
        this.missingNames.entrySet().parallelStream().forEach(entry -> {
            UserImportData importer = (UserImportData)entry.getKey();
            String uuid = (String)entry.getValue();
            String name = (String)foundNames.get(uuid);
            this.foundNames.put(importer, name);
            found.add(importer);
        });
        this.missingNames.keySet().removeAll(found);
    }

    private String getNameByOfflinePlayer(String uuid) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(UUID.fromString(uuid));
        if (!player.hasPlayedBefore()) {
            return null;
        }
        return player.getName();
    }
}

