/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing.data;

import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.gathering.domain.builders.TPSBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ServerImportData {
    private List<TPS> tpsData;

    private ServerImportData(List<TPS> tpsData) {
        this.tpsData = tpsData;
    }

    public static ServerImportDataBuilder builder() {
        return new ServerImportDataBuilder();
    }

    public List<TPS> getTpsData() {
        return this.tpsData;
    }

    public void setTpsData(List<TPS> tpsData) {
        this.tpsData = tpsData;
    }

    public static final class ServerImportDataBuilder {
        private final List<TPS> tpsData = new ArrayList<TPS>();

        private ServerImportDataBuilder() {
        }

        public ServerImportDataBuilder tpsData(long date, double ticksPerSecond, int players, double cpuUsage, long usedMemory, int entityCount, int chunksLoaded) {
            TPS tps = TPSBuilder.get().date(date).tps(ticksPerSecond).playersOnline(players).usedCPU(cpuUsage).usedMemory(usedMemory).entities(entityCount).chunksLoaded(chunksLoaded).toTPS();
            this.tpsData.add(tps);
            return this;
        }

        public ServerImportDataBuilder tpsData(TPS ... tpsData) {
            this.tpsData.addAll(Arrays.asList(tpsData));
            return this;
        }

        public ServerImportDataBuilder tpsData(Collection<TPS> tpsData) {
            this.tpsData.addAll(tpsData);
            return this;
        }

        public ServerImportData build() {
            return new ServerImportData(this.tpsData);
        }
    }
}

