/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing.data;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class UserImportData {
    private String name;
    private UUID uuid;
    private List<Nickname> nicknames;
    private long registered;
    private boolean op;
    private boolean banned;
    private int timesKicked;
    private List<String> ips;
    private Map<String, GMTimes> worldTimes;
    private List<PlayerKill> kills;
    private int mobKills;
    private int deaths;

    private UserImportData(String name, UUID uuid, List<Nickname> nicknames, long registered, boolean op, boolean banned, int timesKicked, List<String> ips, Map<String, GMTimes> worldTimes, List<PlayerKill> kills, int mobKills, int deaths) {
        this.name = name;
        this.uuid = uuid;
        this.nicknames = nicknames;
        this.registered = registered;
        this.op = op;
        this.banned = banned;
        this.timesKicked = timesKicked;
        this.ips = ips;
        this.worldTimes = worldTimes;
        this.kills = kills;
        this.mobKills = mobKills;
        this.deaths = deaths;
    }

    public static UserImportDataBuilder builder(UUID serverUUID) {
        return new UserImportDataBuilder(serverUUID);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public List<Nickname> getNicknames() {
        return this.nicknames;
    }

    public void setNicknames(List<Nickname> nicknames) {
        this.nicknames = nicknames;
    }

    public long getRegistered() {
        return this.registered;
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public boolean isOp() {
        return this.op;
    }

    public void setOp(boolean op) {
        this.op = op;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public int getTimesKicked() {
        return this.timesKicked;
    }

    public void setTimesKicked(int timesKicked) {
        this.timesKicked = timesKicked;
    }

    public List<String> getIps() {
        return this.ips;
    }

    public void setIps(List<String> ips) {
        this.ips = ips;
    }

    public Map<String, GMTimes> getWorldTimes() {
        return this.worldTimes;
    }

    public void setWorldTimes(Map<String, GMTimes> worldTimes) {
        this.worldTimes = worldTimes;
    }

    public List<PlayerKill> getKills() {
        return this.kills;
    }

    public void setKills(List<PlayerKill> kills) {
        this.kills = kills;
    }

    public int getMobKills() {
        return this.mobKills;
    }

    public void setMobKills(int mobKills) {
        this.mobKills = mobKills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserImportData)) {
            return false;
        }
        UserImportData that = (UserImportData)o;
        return this.registered == that.registered && this.op == that.op && this.banned == that.banned && this.timesKicked == that.timesKicked && this.mobKills == that.mobKills && this.deaths == that.deaths && Objects.equals(this.name, that.name) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.nicknames, that.nicknames) && Objects.equals(this.ips, that.ips) && Objects.equals(this.worldTimes, that.worldTimes) && Objects.equals(this.kills, that.kills);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid, this.nicknames, this.registered, this.op, this.banned, this.timesKicked, this.ips, this.worldTimes, this.kills, this.mobKills, this.deaths);
    }

    public static final class UserImportDataBuilder {
        private final UUID serverUUID;
        private final List<Nickname> nicknames = new ArrayList<Nickname>();
        private final List<String> ips = new ArrayList<String>();
        private final Map<String, GMTimes> worldTimes = new HashMap<String, GMTimes>();
        private final List<PlayerKill> kills = new ArrayList<PlayerKill>();
        private String name;
        private UUID uuid;
        private long registered;
        private boolean op;
        private boolean banned;
        private int timesKicked;
        private int mobKills;
        private int deaths;

        private UserImportDataBuilder(UUID serverUUID) {
            this.serverUUID = serverUUID;
        }

        public UserImportDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserImportDataBuilder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public UserImportDataBuilder uuid(String uuid) {
            return this.uuid(UUID.fromString(uuid));
        }

        public UserImportDataBuilder registered(long registered) {
            this.registered = registered;
            return this;
        }

        public UserImportDataBuilder op() {
            return this.op(true);
        }

        public UserImportDataBuilder op(boolean op) {
            this.op = op;
            return this;
        }

        public UserImportDataBuilder nicknames(String ... nicknames) {
            long time = System.currentTimeMillis();
            Arrays.stream(nicknames).map(nick -> new Nickname((String)nick, time, this.serverUUID)).forEach(this.nicknames::add);
            return this;
        }

        public UserImportDataBuilder nicknames(Collection<Nickname> nicknames) {
            this.nicknames.addAll(nicknames);
            return this;
        }

        public UserImportDataBuilder banned() {
            return this.banned(true);
        }

        public UserImportDataBuilder banned(boolean banned) {
            this.banned = banned;
            return this;
        }

        public UserImportDataBuilder timesKicked(int timesKicked) {
            this.timesKicked += timesKicked;
            return this;
        }

        public UserImportDataBuilder ips(String ... ips) {
            this.ips.addAll(Arrays.asList(ips));
            return this;
        }

        public UserImportDataBuilder ips(Collection<String> ips) {
            this.ips.addAll(ips);
            return this;
        }

        public UserImportDataBuilder worldTimes(String worldName, long ... times) {
            GMTimes gmTimes = new GMTimes();
            gmTimes.setAllGMTimes(times);
            this.worldTimes.put(worldName, gmTimes);
            return this;
        }

        public UserImportDataBuilder worldTimes(String worldName, GMTimes gmTimes) {
            this.worldTimes.put(worldName, gmTimes);
            return this;
        }

        public UserImportDataBuilder worldTimes(Map<String, GMTimes> worldTimes) {
            this.worldTimes.putAll(worldTimes);
            return this;
        }

        public UserImportDataBuilder kills(PlayerKill ... kills) {
            this.kills.addAll(Arrays.asList(kills));
            return this;
        }

        public UserImportDataBuilder kills(Collection<PlayerKill> kills) {
            this.kills.addAll(kills);
            return this;
        }

        public UserImportDataBuilder mobKills(int mobKills) {
            this.mobKills += mobKills;
            return this;
        }

        public UserImportDataBuilder deaths(int deaths) {
            this.deaths += deaths;
            return this;
        }

        public UserImportData build() {
            return new UserImportData(this.name, this.uuid, this.nicknames, this.registered, this.op, this.banned, this.timesKicked, this.ips, this.worldTimes, this.kills, this.mobKills, this.deaths);
        }
    }
}

