/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing.importers;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.gathering.domain.BaseUser;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.UserInfo;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import com.djrapitops.plan.gathering.importing.data.BukkitUserImportRefiner;
import com.djrapitops.plan.gathering.importing.data.ServerImportData;
import com.djrapitops.plan.gathering.importing.data.UserImportData;
import com.djrapitops.plan.gathering.importing.importers.Importer;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.LargeStoreQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class BukkitImporter
implements Importer {
    protected final Supplier<UUID> serverUUID;
    private final GeolocationCache geolocationCache;
    private final DBSystem dbSystem;
    private final String name;
    private final Plan plugin;

    protected BukkitImporter(Plan plugin, GeolocationCache geolocationCache, DBSystem dbSystem, ServerInfo serverInfo, String name) {
        this.geolocationCache = geolocationCache;
        this.dbSystem = dbSystem;
        this.serverUUID = serverInfo::getServerUUID;
        this.name = name;
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract ServerImportData getServerImportData();

    public abstract List<UserImportData> getUserImportData();

    @Override
    public final void processImport() {
        ExecutorService service = Executors.newCachedThreadPool();
        try {
            service.submit(this::processServerData);
            service.submit(this::processUserData);
        }
        finally {
            this.shutdownService(service);
        }
    }

    private void processServerData() {
        final ServerImportData serverImportData = this.getServerImportData();
        if (serverImportData == null) {
            return;
        }
        this.dbSystem.getDatabase().executeTransaction(new Transaction(){

            @Override
            protected void performOperations() {
                this.execute(LargeStoreQueries.storeAllTPSData(Collections.singletonMap(BukkitImporter.this.serverUUID.get(), serverImportData.getTpsData())));
            }
        });
    }

    private void processUserData() {
        List<UserImportData> userImportData = this.getUserImportData();
        if (Verify.isEmpty(userImportData)) {
            return;
        }
        BukkitUserImportRefiner userImportRefiner = new BukkitUserImportRefiner(this.plugin, userImportData);
        userImportData = userImportRefiner.refineData();
        Database db = this.dbSystem.getDatabase();
        Set<UUID> existingUUIDs = db.query(UserIdentifierQueries.fetchAllPlayerUUIDs());
        Set<UUID> existingUserInfoTableUUIDs = db.query(UserIdentifierQueries.fetchPlayerUUIDsOfServer(this.serverUUID.get()));
        final HashMap users = new HashMap();
        final ArrayList userInfo = new ArrayList();
        final HashMap nickNames = new HashMap();
        final ArrayList sessions = new ArrayList();
        final HashMap geoInfo = new HashMap();
        userImportData.parallelStream().forEach(data -> {
            UUID uuid = data.getUuid();
            if (!existingUUIDs.contains(uuid)) {
                users.put(uuid, this.toBaseUser((UserImportData)data));
            }
            if (!existingUserInfoTableUUIDs.contains(uuid)) {
                userInfo.add(this.toUserInfo((UserImportData)data));
            }
            nickNames.put(uuid, data.getNicknames());
            geoInfo.put(uuid, this.convertGeoInfo((UserImportData)data));
            sessions.add(this.toSession((UserImportData)data));
        });
        db.executeTransaction(new Transaction(){

            @Override
            protected void performOperations() {
                this.execute(LargeStoreQueries.storeAllCommonUserInformation(users.values()));
                this.execute(LargeStoreQueries.storeAllSessionsWithKillAndWorldData(sessions));
                Map<UUID, List<UserInfo>> userInformation = Collections.singletonMap(BukkitImporter.this.serverUUID.get(), userInfo);
                this.execute(LargeStoreQueries.storePerServerUserInformation(userInformation));
                this.execute(LargeStoreQueries.storeAllNicknameData(Collections.singletonMap(BukkitImporter.this.serverUUID.get(), nickNames)));
                this.execute(LargeStoreQueries.storeAllGeoInformation(geoInfo));
            }
        });
    }

    private void shutdownService(ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(20L, TimeUnit.MINUTES)) {
                service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private BaseUser toBaseUser(UserImportData userImportData) {
        UUID playerUUID = userImportData.getUuid();
        String playerName = userImportData.getName();
        long registered = userImportData.getRegistered();
        int timesKicked = userImportData.getTimesKicked();
        return new BaseUser(playerUUID, playerName, registered, timesKicked);
    }

    private UserInfo toUserInfo(UserImportData userImportData) {
        UUID uuid = userImportData.getUuid();
        long registered = userImportData.getRegistered();
        boolean op = userImportData.isOp();
        boolean banned = userImportData.isBanned();
        return new UserInfo(uuid, this.serverUUID.get(), registered, op, banned);
    }

    private Session toSession(UserImportData userImportData) {
        int mobKills = userImportData.getMobKills();
        int deaths = userImportData.getDeaths();
        Session session = new Session(0, userImportData.getUuid(), this.serverUUID.get(), 0L, 0L, mobKills, deaths, 0L);
        session.setPlayerKills(userImportData.getKills());
        session.setWorldTimes(new WorldTimes(userImportData.getWorldTimes()));
        return session;
    }

    private List<GeoInfo> convertGeoInfo(UserImportData userImportData) {
        long date = System.currentTimeMillis();
        return userImportData.getIps().stream().map(this.geolocationCache::getCountry).filter(Objects::nonNull).map(geoLocation -> new GeoInfo((String)geoLocation, date)).collect(Collectors.toList());
    }
}

