/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.importing.importers;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import com.djrapitops.plan.gathering.importing.data.ServerImportData;
import com.djrapitops.plan.gathering.importing.data.UserImportData;
import com.djrapitops.plan.gathering.importing.importers.BukkitImporter;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class OfflinePlayerImporter
extends BukkitImporter {
    @Inject
    public OfflinePlayerImporter(Plan plugin, GeolocationCache geolocationCache, DBSystem dbSystem, ServerInfo serverInfo) {
        super(plugin, geolocationCache, dbSystem, serverInfo, "offline");
    }

    @Override
    public ServerImportData getServerImportData() {
        return null;
    }

    @Override
    public List<UserImportData> getUserImportData() {
        ArrayList<UserImportData> dataList = new ArrayList<UserImportData>();
        Set operators = Bukkit.getOperators();
        Set banned = Bukkit.getBannedPlayers();
        ((Stream)Arrays.stream(Bukkit.getOfflinePlayers()).parallel()).forEach(player -> {
            UserImportData.UserImportDataBuilder builder = UserImportData.builder((UUID)this.serverUUID.get());
            builder.name(player.getName()).uuid(player.getUniqueId()).registered(player.getFirstPlayed());
            if (operators.contains(player)) {
                builder.op();
            }
            if (banned.contains(player)) {
                builder.banned();
            }
            dataList.add(builder.build());
        });
        return dataList;
    }
}

