/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.api.events.PlanBukkitEnableEvent;
import com.djrapitops.plan.capability.CapabilitySvc;
import com.djrapitops.plan.gathering.listeners.ListenerSystem;
import com.djrapitops.plan.gathering.listeners.Status;
import com.djrapitops.plan.gathering.listeners.bukkit.BukkitAFKListener;
import com.djrapitops.plan.gathering.listeners.bukkit.ChatListener;
import com.djrapitops.plan.gathering.listeners.bukkit.DeathEventListener;
import com.djrapitops.plan.gathering.listeners.bukkit.GameModeChangeListener;
import com.djrapitops.plan.gathering.listeners.bukkit.PlayerOnlineListener;
import com.djrapitops.plan.gathering.listeners.bukkit.WorldChangeListener;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import plan.javax.inject.Inject;

public class BukkitListenerSystem
extends ListenerSystem {
    private final Plan plugin;
    private final Status status;
    private final PlayerOnlineListener playerOnlineListener;
    private final ChatListener chatListener;
    private final GameModeChangeListener gamemodeChangeListener;
    private final WorldChangeListener worldChangeListener;
    private final DeathEventListener deathEventListener;
    private final BukkitAFKListener afkListener;

    @Inject
    public BukkitListenerSystem(Plan plugin, Status status, PlayerOnlineListener playerOnlineListener, ChatListener chatListener, GameModeChangeListener gamemodeChangeListener, WorldChangeListener worldChangeListener, DeathEventListener deathEventListener, BukkitAFKListener afkListener) {
        this.plugin = plugin;
        this.status = status;
        this.playerOnlineListener = playerOnlineListener;
        this.chatListener = chatListener;
        this.gamemodeChangeListener = gamemodeChangeListener;
        this.worldChangeListener = worldChangeListener;
        this.deathEventListener = deathEventListener;
        this.afkListener = afkListener;
    }

    @Override
    protected void registerListeners() {
        this.plugin.registerListener(this.playerOnlineListener, this.chatListener, this.gamemodeChangeListener, this.worldChangeListener, this.deathEventListener, this.afkListener);
        this.status.setCountKicks(true);
    }

    @Override
    protected void unregisterListeners() {
        HandlerList.unregisterAll((Plugin)this.plugin);
    }

    @Override
    public void callEnableEvent(PlanPlugin plugin) {
        boolean isEnabled = plugin.isSystemEnabled();
        PlanBukkitEnableEvent event = new PlanBukkitEnableEvent(isEnabled);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CapabilitySvc.notifyAboutEnable(isEnabled);
    }
}

