/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners;

import com.djrapitops.plan.PlanBungee;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.api.events.PlanBungeeEnableEvent;
import com.djrapitops.plan.capability.CapabilitySvc;
import com.djrapitops.plan.gathering.listeners.ListenerSystem;
import com.djrapitops.plan.gathering.listeners.bungee.PlayerOnlineListener;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Plugin;
import plan.javax.inject.Inject;

public class BungeeListenerSystem
extends ListenerSystem {
    private final PlanBungee plugin;
    private PlayerOnlineListener playerOnlineListener;

    @Inject
    public BungeeListenerSystem(PlanBungee plugin, PlayerOnlineListener playerOnlineListener) {
        this.plugin = plugin;
        this.playerOnlineListener = playerOnlineListener;
    }

    @Override
    protected void registerListeners() {
        this.plugin.registerListener(this.playerOnlineListener);
    }

    @Override
    protected void unregisterListeners() {
        this.plugin.getProxy().getPluginManager().unregisterListeners((Plugin)this.plugin);
    }

    @Override
    public void callEnableEvent(PlanPlugin plugin) {
        boolean isEnabled = plugin.isSystemEnabled();
        PlanBungeeEnableEvent event = new PlanBungeeEnableEvent(isEnabled);
        ((PlanBungee)plugin).getProxy().getPluginManager().callEvent((Event)event);
        CapabilitySvc.notifyAboutEnable(isEnabled);
    }
}

