/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanSponge;
import com.djrapitops.plan.SpongeServerShutdownSave;
import com.djrapitops.plan.api.events.PlanSpongeEnableEvent;
import com.djrapitops.plan.capability.CapabilitySvc;
import com.djrapitops.plan.gathering.listeners.ListenerSystem;
import com.djrapitops.plan.gathering.listeners.sponge.PlayerOnlineListener;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeAFKListener;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeChatListener;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeDeathListener;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeGMChangeListener;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeWorldChangeListener;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import plan.javax.inject.Inject;

public class SpongeListenerSystem
extends ListenerSystem {
    private final PlanSponge plugin;
    private final SpongeAFKListener afkListener;
    private final SpongeChatListener chatListener;
    private final SpongeDeathListener deathListener;
    private final SpongeGMChangeListener gmChangeListener;
    private final PlayerOnlineListener playerListener;
    private final SpongeWorldChangeListener worldChangeListener;
    private final SpongeServerShutdownSave spongeServerShutdownSave;

    @Inject
    public SpongeListenerSystem(PlanSponge plugin, SpongeAFKListener afkListener, SpongeChatListener chatListener, SpongeDeathListener deathListener, SpongeGMChangeListener gmChangeListener, PlayerOnlineListener playerListener, SpongeWorldChangeListener worldChangeListener, SpongeServerShutdownSave spongeServerShutdownSave) {
        this.plugin = plugin;
        this.afkListener = afkListener;
        this.chatListener = chatListener;
        this.deathListener = deathListener;
        this.gmChangeListener = gmChangeListener;
        this.playerListener = playerListener;
        this.worldChangeListener = worldChangeListener;
        this.spongeServerShutdownSave = spongeServerShutdownSave;
    }

    @Override
    protected void registerListeners() {
        this.plugin.registerListener(this.afkListener, this.chatListener, this.deathListener, this.playerListener, this.gmChangeListener, this.worldChangeListener, this.spongeServerShutdownSave);
    }

    @Override
    protected void unregisterListeners() {
        try {
            Sponge.getEventManager().unregisterPluginListeners((Object)this.plugin);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void callEnableEvent(PlanPlugin plugin) {
        try {
            PlanSpongeEnableEvent event = new PlanSpongeEnableEvent((PlanSponge)plugin);
            Sponge.getEventManager().post((Event)event);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CapabilitySvc.notifyAboutEnable(plugin.isSystemEnabled());
    }
}

