/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanVelocity;
import com.djrapitops.plan.api.events.PlanVelocityEnableEvent;
import com.djrapitops.plan.capability.CapabilitySvc;
import com.djrapitops.plan.gathering.listeners.ListenerSystem;
import com.djrapitops.plan.gathering.listeners.velocity.PlayerOnlineListener;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class VelocityListenerSystem
extends ListenerSystem {
    private final PlanVelocity plugin;
    private final PlayerOnlineListener playerOnlineListener;

    @Inject
    public VelocityListenerSystem(PlanVelocity plugin, PlayerOnlineListener playerOnlineListener) {
        this.plugin = plugin;
        this.playerOnlineListener = playerOnlineListener;
    }

    @Override
    protected void registerListeners() {
        this.plugin.registerListener(this.playerOnlineListener);
    }

    @Override
    protected void unregisterListeners() {
        this.plugin.getProxy().getEventManager().unregisterListeners((Object)this.plugin);
    }

    @Override
    public void callEnableEvent(PlanPlugin plugin) {
        boolean isEnabled = plugin.isSystemEnabled();
        PlanVelocityEnableEvent event = new PlanVelocityEnableEvent(isEnabled);
        ((PlanVelocity)plugin).getProxy().getEventManager().fireAndForget((Object)event);
        CapabilitySvc.notifyAboutEnable(isEnabled);
    }
}

