/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.bukkit;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.gathering.cache.NicknameCache;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.NicknameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import plan.javax.inject.Inject;

public class ChatListener
implements Listener {
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final NicknameCache nicknameCache;
    private final ErrorLogger errorLogger;

    @Inject
    public ChatListener(ServerInfo serverInfo, DBSystem dbSystem, NicknameCache nicknameCache, ErrorLogger errorLogger) {
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.nicknameCache = nicknameCache;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            this.actOnChatEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnChatEvent(AsyncPlayerChatEvent event) {
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String displayName = player.getDisplayName();
        this.dbSystem.getDatabase().executeTransaction(new NicknameStoreTransaction(uuid, new Nickname(displayName, time, this.serverInfo.getServerUUID()), (playerUUID, name) -> this.nicknameCache.getDisplayName((UUID)playerUUID).map(name::equals).orElse(false)));
    }
}

