/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.bukkit;

import com.djrapitops.plan.delivery.formatting.EntityNameFormatter;
import com.djrapitops.plan.delivery.formatting.ItemNameFormatter;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.processing.processors.player.MobKillProcessor;
import com.djrapitops.plan.processing.processors.player.PlayerKillProcessor;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import plan.javax.inject.Inject;

public class DeathEventListener
implements Listener {
    private final Processing processing;
    private final ErrorLogger errorLogger;

    @Inject
    public DeathEventListener(Processing processing, ErrorLogger errorLogger) {
        this.processing = processing;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(EntityDeathEvent event) {
        long time = System.currentTimeMillis();
        LivingEntity dead = event.getEntity();
        if (dead instanceof Player) {
            SessionCache.getCachedSession(dead.getUniqueId()).ifPresent(Session::died);
        }
        try {
            EntityDamageEvent entityDamageEvent = dead.getLastDamageCause();
            if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
                return;
            }
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity killerEntity = entityDamageByEntityEvent.getDamager();
            UUID uuid = dead instanceof Player ? dead.getUniqueId() : null;
            this.handleKill(time, uuid, killerEntity);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related(event, dead).build());
        }
    }

    private void handleKill(long time, UUID victimUUID, Entity killerEntity) {
        Runnable processor = null;
        if (killerEntity instanceof Player) {
            processor = this.handlePlayerKill(time, victimUUID, (Player)killerEntity);
        } else if (killerEntity instanceof Tameable) {
            processor = this.handlePetKill(time, victimUUID, (Tameable)killerEntity);
        } else if (killerEntity instanceof Projectile) {
            processor = this.handleProjectileKill(time, victimUUID, (Projectile)killerEntity);
        }
        if (processor != null) {
            this.processing.submit(processor);
        }
    }

    private Runnable handlePlayerKill(long time, UUID victimUUID, Player killer) {
        Material itemInHand;
        try {
            itemInHand = killer.getInventory().getItemInMainHand().getType();
        }
        catch (NoSuchMethodError oldVersion) {
            try {
                itemInHand = killer.getInventory().getItemInHand().getType();
            }
            catch (Exception | NoSuchFieldError | NoSuchMethodError unknownError) {
                itemInHand = Material.AIR;
            }
        }
        String weaponName = new ItemNameFormatter().apply(itemInHand.name());
        return victimUUID != null ? new PlayerKillProcessor(killer.getUniqueId(), time, victimUUID, weaponName) : new MobKillProcessor(killer.getUniqueId());
    }

    private Runnable handlePetKill(long time, UUID victimUUID, Tameable tameable) {
        String name;
        if (!tameable.isTamed()) {
            return null;
        }
        AnimalTamer owner = tameable.getOwner();
        if (!(owner instanceof Player)) {
            return null;
        }
        try {
            name = tameable.getType().name();
        }
        catch (NoSuchMethodError oldVersionNoTypesError) {
            name = tameable.getClass().getSimpleName();
        }
        return victimUUID != null ? new PlayerKillProcessor(owner.getUniqueId(), time, victimUUID, new EntityNameFormatter().apply(name)) : new MobKillProcessor(owner.getUniqueId());
    }

    private Runnable handleProjectileKill(long time, UUID victimUUID, Projectile projectile) {
        ProjectileSource source = projectile.getShooter();
        if (!(source instanceof Player)) {
            return null;
        }
        Player player = (Player)source;
        String projectileName = new EntityNameFormatter().apply(projectile.getType().name());
        return victimUUID != null ? new PlayerKillProcessor(player.getUniqueId(), time, victimUUID, projectileName) : new MobKillProcessor(player.getUniqueId());
    }
}

