/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.bungee;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.ExtensionSvc;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.events.GeoInfoStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.PlayerRegisterTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.net.InetAddress;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import plan.javax.inject.Inject;

public class PlayerOnlineListener
implements Listener {
    private final PlanConfig config;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ExtensionSvc extensionService;
    private final Exporter exporter;
    private final GeolocationCache geolocationCache;
    private final SessionCache sessionCache;
    private final ServerInfo serverInfo;
    private final ErrorLogger errorLogger;

    @Inject
    public PlayerOnlineListener(PlanConfig config, Processing processing, DBSystem dbSystem, ExtensionSvc extensionService, Exporter exporter, GeolocationCache geolocationCache, SessionCache sessionCache, ServerInfo serverInfo, ErrorLogger errorLogger) {
        this.config = config;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.extensionService = extensionService;
        this.exporter = exporter;
        this.geolocationCache = geolocationCache;
        this.sessionCache = sessionCache;
        this.serverInfo = serverInfo;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=64)
    public void onPostLogin(PostLoginEvent event) {
        try {
            this.actOnLogin(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnLogin(PostLoginEvent event) {
        ProxiedPlayer player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        InetAddress address = player.getAddress().getAddress();
        long time = System.currentTimeMillis();
        Session session = new Session(playerUUID, this.serverInfo.getServerUUID(), time, null, null);
        session.putRawData(SessionKeys.NAME, playerName);
        session.putRawData(SessionKeys.SERVER_NAME, "Proxy Server");
        this.sessionCache.cacheSession(playerUUID, session);
        Database database = this.dbSystem.getDatabase();
        boolean gatheringGeolocations = this.config.isTrue(DataGatheringSettings.GEOLOCATIONS);
        if (gatheringGeolocations) {
            database.executeTransaction(new GeoInfoStoreTransaction(playerUUID, address, time, this.geolocationCache::getCountry));
        }
        database.executeTransaction(new PlayerRegisterTransaction(playerUUID, () -> time, playerName));
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_JOIN));
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
        UUID serverUUID = this.serverInfo.getServerUUID();
        JSONCache.invalidateMatching(DataID.SERVER_OVERVIEW);
        JSONCache.invalidate(DataID.GRAPH_ONLINE, serverUUID);
        JSONCache.invalidate(DataID.SERVERS);
        JSONCache.invalidate(DataID.SESSIONS);
    }

    @EventHandler(priority=0)
    public void beforeLogout(PlayerDisconnectEvent event) {
        ProxiedPlayer player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_LEAVE));
    }

    @EventHandler(priority=64)
    public void onLogout(PlayerDisconnectEvent event) {
        try {
            this.actOnLogout(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnLogout(PlayerDisconnectEvent event) {
        ProxiedPlayer player = event.getPlayer();
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        this.sessionCache.endSession(playerUUID, System.currentTimeMillis());
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
        this.processing.submit(() -> {
            JSONCache.invalidateMatching(DataID.SERVER_OVERVIEW, DataID.SESSIONS, DataID.GRAPH_WORLD_PIE, DataID.GRAPH_PUNCHCARD, DataID.KILLS, DataID.ONLINE_OVERVIEW, DataID.SESSIONS_OVERVIEW, DataID.PVP_PVE, DataID.GRAPH_UNIQUE_NEW, DataID.GRAPH_CALENDAR);
            UUID serverUUID = this.serverInfo.getServerUUID();
            JSONCache.invalidate(DataID.GRAPH_ONLINE, serverUUID);
            JSONCache.invalidate(DataID.SERVERS);
        });
    }

    @EventHandler(priority=64)
    public void onServerSwitch(ServerSwitchEvent event) {
        try {
            this.actOnServerSwitch(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnServerSwitch(ServerSwitchEvent event) {
        ProxiedPlayer player = event.getPlayer();
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        long time = System.currentTimeMillis();
        Session session = new Session(playerUUID, this.serverInfo.getServerUUID(), time, null, null);
        session.putRawData(SessionKeys.NAME, playerName);
        session.putRawData(SessionKeys.SERVER_NAME, "Proxy Server");
        this.sessionCache.cacheSession(playerUUID, session);
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
        JSONCache.invalidate(DataID.SERVERS);
    }
}

