/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.nukkit;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.passive.EntityTameable;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityDeathEvent;
import cn.nukkit.event.player.PlayerDeathEvent;
import cn.nukkit.item.Item;
import com.djrapitops.plan.delivery.formatting.EntityNameFormatter;
import com.djrapitops.plan.delivery.formatting.ItemNameFormatter;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.processing.processors.player.MobKillProcessor;
import com.djrapitops.plan.processing.processors.player.PlayerKillProcessor;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.UUID;
import plan.javax.inject.Inject;

public class DeathEventListener
implements Listener {
    private final Processing processing;
    private final ErrorLogger errorLogger;

    @Inject
    public DeathEventListener(Processing processing, ErrorLogger errorLogger) {
        this.processing = processing;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        long time = System.currentTimeMillis();
        Player dead = event.getEntity();
        SessionCache.getCachedSession(dead.getUniqueId()).ifPresent(Session::died);
        try {
            EntityDamageEvent entityDamageEvent = dead.getLastDamageCause();
            if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
                return;
            }
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity killerEntity = entityDamageByEntityEvent.getDamager();
            UUID uuid = dead.getUniqueId();
            this.handleKill(time, uuid, killerEntity);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related(event, dead).build());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMobDeath(EntityDeathEvent event) {
        long time = System.currentTimeMillis();
        Entity dead = event.getEntity();
        try {
            EntityDamageEvent entityDamageEvent = dead.getLastDamageCause();
            if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
                return;
            }
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity killerEntity = entityDamageByEntityEvent.getDamager();
            this.handleKill(time, null, killerEntity);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related(event, dead).build());
        }
    }

    private void handleKill(long time, UUID victimUUID, Entity killerEntity) {
        Runnable processor = null;
        if (killerEntity instanceof Player) {
            processor = this.handlePlayerKill(time, victimUUID, (Player)killerEntity);
        } else if (killerEntity instanceof EntityTameable) {
            processor = this.handlePetKill(time, victimUUID, (EntityTameable)killerEntity);
        } else if (killerEntity instanceof EntityProjectile) {
            processor = this.handleProjectileKill(time, victimUUID, (EntityProjectile)killerEntity);
        }
        if (processor != null) {
            this.processing.submit(processor);
        }
    }

    private Runnable handlePlayerKill(long time, UUID victimUUID, Player killer) {
        Item itemInHand = killer.getInventory().getItemInHand();
        String weaponName = new ItemNameFormatter().apply(itemInHand.getName());
        return victimUUID != null ? new PlayerKillProcessor(killer.getUniqueId(), time, victimUUID, weaponName) : new MobKillProcessor(killer.getUniqueId());
    }

    private Runnable handlePetKill(long time, UUID victimUUID, EntityTameable tameable) {
        String name;
        if (!tameable.isTamed()) {
            return null;
        }
        Player owner = tameable.getOwner();
        try {
            name = tameable.getName();
        }
        catch (NoSuchMethodError oldVersionNoTypesError) {
            name = tameable.getClass().getSimpleName();
        }
        return victimUUID != null ? new PlayerKillProcessor(owner.getUniqueId(), time, victimUUID, new EntityNameFormatter().apply(name)) : new MobKillProcessor(owner.getUniqueId());
    }

    private Runnable handleProjectileKill(long time, UUID victimUUID, EntityProjectile projectile) {
        Entity source = projectile.shootingEntity;
        if (!(source instanceof Player)) {
            return null;
        }
        Player player = (Player)source;
        String projectileName = new EntityNameFormatter().apply(projectile.getName());
        return victimUUID != null ? new PlayerKillProcessor(player.getUniqueId(), time, victimUUID, projectileName) : new MobKillProcessor(player.getUniqueId());
    }
}

