/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.nukkit;

import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import com.djrapitops.plan.gathering.afk.AFKTracker;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import plan.javax.inject.Inject;

public class NukkitAFKListener
implements Listener {
    static AFKTracker AFK_TRACKER;
    private final Map<UUID, Boolean> ignorePermissionInfo;
    private final ErrorLogger errorLogger;

    @Inject
    public NukkitAFKListener(PlanConfig config, ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
        this.ignorePermissionInfo = new HashMap<UUID, Boolean>();
        NukkitAFKListener.assignAFKTracker(config);
    }

    private static void assignAFKTracker(PlanConfig config) {
        if (AFK_TRACKER == null) {
            AFK_TRACKER = new AFKTracker(config);
        }
    }

    private void event(PlayerEvent event) {
        try {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            long time = System.currentTimeMillis();
            boolean ignored = this.ignorePermissionInfo.computeIfAbsent(uuid, keyUUID -> player.hasPermission(Permissions.IGNORE_AFK.getPermission()));
            if (ignored) {
                AFK_TRACKER.hasIgnorePermission(uuid);
                this.ignorePermissionInfo.put(uuid, true);
                return;
            }
            this.ignorePermissionInfo.put(uuid, false);
            AFK_TRACKER.performedAction(uuid, time);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        this.event((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(PlayerChatEvent event) {
        this.event((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        this.event((PlayerEvent)event);
        boolean isAfkCommand = event.getMessage().substring(1).toLowerCase().startsWith("afk");
        if (isAfkCommand) {
            UUID uuid = event.getPlayer().getUniqueId();
            AFK_TRACKER.usedAfkCommand(uuid, System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeave(PlayerQuitEvent event) {
        this.ignorePermissionInfo.remove(event.getPlayer().getUniqueId());
    }
}

