/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.nukkit;

import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerKickEvent;
import cn.nukkit.event.player.PlayerLoginEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.ExtensionSvc;
import com.djrapitops.plan.gathering.cache.NicknameCache;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import com.djrapitops.plan.gathering.listeners.Status;
import com.djrapitops.plan.gathering.listeners.nukkit.NukkitAFKListener;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.events.BanStatusTransaction;
import com.djrapitops.plan.storage.database.transactions.events.GeoInfoStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.KickStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.NicknameStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.OperatorStatusTransaction;
import com.djrapitops.plan.storage.database.transactions.events.PlayerServerRegisterTransaction;
import com.djrapitops.plan.storage.database.transactions.events.SessionEndTransaction;
import com.djrapitops.plan.storage.database.transactions.events.WorldNameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;

public class PlayerOnlineListener
implements Listener {
    private final PlanConfig config;
    private final Processing processing;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final ExtensionSvc extensionService;
    private final Exporter exporter;
    private final GeolocationCache geolocationCache;
    private final NicknameCache nicknameCache;
    private final SessionCache sessionCache;
    private final ErrorLogger errorLogger;
    private final Status status;

    @Inject
    public PlayerOnlineListener(PlanConfig config, Processing processing, ServerInfo serverInfo, DBSystem dbSystem, ExtensionSvc extensionService, Exporter exporter, GeolocationCache geolocationCache, NicknameCache nicknameCache, SessionCache sessionCache, Status status, ErrorLogger errorLogger) {
        this.config = config;
        this.processing = processing;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.extensionService = extensionService;
        this.exporter = exporter;
        this.geolocationCache = geolocationCache;
        this.nicknameCache = nicknameCache;
        this.sessionCache = sessionCache;
        this.status = status;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(PlayerLoginEvent event) {
        try {
            UUID playerUUID = event.getPlayer().getUniqueId();
            boolean operator = event.getPlayer().isOp();
            this.dbSystem.getDatabase().executeTransaction(new OperatorStatusTransaction(playerUUID, operator));
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        try {
            if (!this.status.areKicksCounted() || event.isCancelled()) {
                return;
            }
            UUID uuid = event.getPlayer().getUniqueId();
            if (NukkitAFKListener.AFK_TRACKER.isAfk(uuid)) {
                return;
            }
            this.dbSystem.getDatabase().executeTransaction(new KickStoreTransaction(uuid));
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        try {
            this.actOnJoinEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        UUID serverUUID = this.serverInfo.getServerUUID();
        long time = System.currentTimeMillis();
        JSONCache.invalidate(DataID.SERVER_OVERVIEW, serverUUID);
        JSONCache.invalidate(DataID.GRAPH_PERFORMANCE, serverUUID);
        NukkitAFKListener.AFK_TRACKER.performedAction(playerUUID, time);
        String world = player.getLevel().getName();
        String gm = GMTimes.magicNumberToGMName(player.getGamemode());
        Database database = this.dbSystem.getDatabase();
        database.executeTransaction(new WorldNameStoreTransaction(serverUUID, world));
        String address = player.getAddress();
        String playerName = player.getName();
        String displayName = player.getDisplayName();
        boolean gatheringGeolocations = this.config.isTrue(DataGatheringSettings.GEOLOCATIONS);
        if (gatheringGeolocations) {
            database.executeTransaction(new GeoInfoStoreTransaction(playerUUID, address, time, this.geolocationCache::getCountry));
        }
        long registerDate = TimeUnit.SECONDS.toMillis(player.getFirstPlayed());
        database.executeTransaction(new PlayerServerRegisterTransaction(playerUUID, () -> registerDate, playerName, serverUUID));
        Session session = new Session(playerUUID, serverUUID, time, world, gm);
        session.putRawData(SessionKeys.NAME, playerName);
        session.putRawData(SessionKeys.SERVER_NAME, this.serverInfo.getServer().getIdentifiableName());
        this.sessionCache.cacheSession(playerUUID, session).ifPresent(previousSession -> database.executeTransaction(new SessionEndTransaction((Session)previousSession)));
        database.executeTransaction(new NicknameStoreTransaction(playerUUID, new Nickname(displayName, time, serverUUID), (uuid, name) -> this.nicknameCache.getDisplayName(playerUUID).map(name::equals).orElse(false)));
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_JOIN));
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void beforePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_LEAVE));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        try {
            this.actOnQuitEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnQuitEvent(PlayerQuitEvent event) {
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        if (playerUUID == null) {
            return;
        }
        UUID serverUUID = this.serverInfo.getServerUUID();
        JSONCache.invalidate(DataID.SERVER_OVERVIEW, serverUUID);
        JSONCache.invalidate(DataID.GRAPH_PERFORMANCE, serverUUID);
        NukkitAFKListener.AFK_TRACKER.loggedOut(playerUUID, time);
        this.nicknameCache.removeDisplayName(playerUUID);
        this.dbSystem.getDatabase().executeTransaction(new BanStatusTransaction(playerUUID, () -> ((Player)player).isBanned()));
        this.sessionCache.endSession(playerUUID, time).ifPresent(endedSession -> this.dbSystem.getDatabase().executeTransaction(new SessionEndTransaction((Session)endedSession)));
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
    }
}

