/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.nukkit;

import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.entity.EntityLevelChangeEvent;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.WorldAliasSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.WorldNameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;

public class WorldChangeListener
implements Listener {
    private final WorldAliasSettings worldAliasSettings;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public WorldChangeListener(WorldAliasSettings worldAliasSettings, ServerInfo serverInfo, DBSystem dbSystem, ErrorLogger errorLogger) {
        this.worldAliasSettings = worldAliasSettings;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(EntityLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            try {
                this.actOnEvent(event);
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
            }
        }
    }

    private void actOnEvent(EntityLevelChangeEvent event) {
        long time = System.currentTimeMillis();
        Player player = (Player)event.getEntity();
        UUID uuid = player.getUniqueId();
        String worldName = player.getLevel().getName();
        String gameMode = GMTimes.magicNumberToGMName(player.getGamemode());
        this.dbSystem.getDatabase().executeTransaction(new WorldNameStoreTransaction(this.serverInfo.getServerUUID(), worldName));
        this.worldAliasSettings.addWorld(worldName);
        Optional<Session> cachedSession = SessionCache.getCachedSession(uuid);
        cachedSession.ifPresent(session -> session.changeState(worldName, gameMode, time));
    }
}

