/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.sponge;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.ExtensionSvc;
import com.djrapitops.plan.gathering.cache.NicknameCache;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.geolocation.GeolocationCache;
import com.djrapitops.plan.gathering.listeners.Status;
import com.djrapitops.plan.gathering.listeners.sponge.SpongeAFKListener;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.events.BanStatusTransaction;
import com.djrapitops.plan.storage.database.transactions.events.GeoInfoStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.KickStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.NicknameStoreTransaction;
import com.djrapitops.plan.storage.database.transactions.events.PlayerServerRegisterTransaction;
import com.djrapitops.plan.storage.database.transactions.events.SessionEndTransaction;
import com.djrapitops.plan.storage.database.transactions.events.WorldNameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.living.humanoid.player.KickPlayerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.text.Text;
import plan.javax.inject.Inject;

public class PlayerOnlineListener {
    private final PlanConfig config;
    private final Processing processing;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final ExtensionSvc extensionService;
    private final Exporter exporter;
    private final GeolocationCache geolocationCache;
    private final NicknameCache nicknameCache;
    private final SessionCache sessionCache;
    private final Status status;
    private final ErrorLogger errorLogger;

    @Inject
    public PlayerOnlineListener(PlanConfig config, Processing processing, ServerInfo serverInfo, DBSystem dbSystem, ExtensionSvc extensionService, Exporter exporter, GeolocationCache geolocationCache, NicknameCache nicknameCache, SessionCache sessionCache, Status status, ErrorLogger errorLogger) {
        this.config = config;
        this.processing = processing;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.extensionService = extensionService;
        this.exporter = exporter;
        this.geolocationCache = geolocationCache;
        this.nicknameCache = nicknameCache;
        this.sessionCache = sessionCache;
        this.status = status;
        this.errorLogger = errorLogger;
    }

    @Listener(order=Order.POST)
    public void onLogin(ClientConnectionEvent.Login event) {
        try {
            this.actOnLoginEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnLoginEvent(ClientConnectionEvent.Login event) {
        GameProfile profile = event.getProfile();
        UUID playerUUID = profile.getUniqueId();
        boolean banned = this.isBanned(profile);
        this.dbSystem.getDatabase().executeTransaction(new BanStatusTransaction(playerUUID, () -> banned));
    }

    @Listener(order=Order.POST)
    public void onKick(KickPlayerEvent event) {
        try {
            UUID playerUUID = event.getTargetEntity().getUniqueId();
            if (!this.status.areKicksCounted() || SpongeAFKListener.AFK_TRACKER.isAfk(playerUUID)) {
                return;
            }
            this.dbSystem.getDatabase().executeTransaction(new KickStoreTransaction(playerUUID));
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private boolean isBanned(GameProfile profile) {
        Optional banService = Sponge.getServiceManager().getRegistration(BanService.class);
        boolean banned = false;
        if (banService.isPresent()) {
            banned = ((BanService)((ProviderRegistration)banService.get()).getProvider()).isBanned(profile);
        }
        return banned;
    }

    @Listener(order=Order.POST)
    public void onJoin(ClientConnectionEvent.Join event) {
        try {
            this.actOnJoinEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnJoinEvent(ClientConnectionEvent.Join event) {
        Player player = event.getTargetEntity();
        UUID playerUUID = player.getUniqueId();
        UUID serverUUID = this.serverInfo.getServerUUID();
        long time = System.currentTimeMillis();
        JSONCache.invalidate(DataID.SERVER_OVERVIEW, serverUUID);
        JSONCache.invalidate(DataID.GRAPH_PERFORMANCE, serverUUID);
        SpongeAFKListener.AFK_TRACKER.performedAction(playerUUID, time);
        String world = player.getWorld().getName();
        Optional gameMode = player.getGameModeData().get(Keys.GAME_MODE);
        String gm = gameMode.map(mode -> mode.getName().toUpperCase()).orElse("ADVENTURE");
        Database database = this.dbSystem.getDatabase();
        database.executeTransaction(new WorldNameStoreTransaction(serverUUID, world));
        InetAddress address = player.getConnection().getAddress().getAddress();
        String playerName = player.getName();
        String displayName = ((Text)player.getDisplayNameData().displayName().get()).toPlain();
        boolean gatheringGeolocations = this.config.isTrue(DataGatheringSettings.GEOLOCATIONS);
        if (gatheringGeolocations) {
            database.executeTransaction(new GeoInfoStoreTransaction(playerUUID, address, time, this.geolocationCache::getCountry));
        }
        database.executeTransaction(new PlayerServerRegisterTransaction(playerUUID, () -> time, playerName, serverUUID));
        Session session = new Session(playerUUID, serverUUID, time, world, gm);
        session.putRawData(SessionKeys.NAME, playerName);
        session.putRawData(SessionKeys.SERVER_NAME, this.serverInfo.getServer().getIdentifiableName());
        this.sessionCache.cacheSession(playerUUID, session).ifPresent(previousSession -> database.executeTransaction(new SessionEndTransaction((Session)previousSession)));
        database.executeTransaction(new NicknameStoreTransaction(playerUUID, new Nickname(displayName, time, serverUUID), (uuid, name) -> this.nicknameCache.getDisplayName(playerUUID).map(name::equals).orElse(false)));
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_JOIN));
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
    }

    @Listener(order=Order.DEFAULT)
    public void beforeQuit(ClientConnectionEvent.Disconnect event) {
        Player player = event.getTargetEntity();
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(playerUUID, playerName, CallEvents.PLAYER_LEAVE));
    }

    @Listener(order=Order.POST)
    public void onQuit(ClientConnectionEvent.Disconnect event) {
        try {
            this.actOnQuitEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnQuitEvent(ClientConnectionEvent.Disconnect event) {
        long time = System.currentTimeMillis();
        Player player = event.getTargetEntity();
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        UUID serverUUID = this.serverInfo.getServerUUID();
        JSONCache.invalidate(DataID.SERVER_OVERVIEW, serverUUID);
        JSONCache.invalidate(DataID.GRAPH_PERFORMANCE, serverUUID);
        SpongeAFKListener.AFK_TRACKER.loggedOut(playerUUID, time);
        this.nicknameCache.removeDisplayName(playerUUID);
        boolean banned = this.isBanned(player.getProfile());
        this.dbSystem.getDatabase().executeTransaction(new BanStatusTransaction(playerUUID, () -> banned));
        this.sessionCache.endSession(playerUUID, time).ifPresent(endedSession -> this.dbSystem.getDatabase().executeTransaction(new SessionEndTransaction((Session)endedSession)));
        if (this.config.isTrue(ExportSettings.EXPORT_ON_ONLINE_STATUS_CHANGE)) {
            this.processing.submitNonCritical(() -> this.exporter.exportPlayerPage(playerUUID, playerName));
        }
    }
}

