/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.sponge;

import com.djrapitops.plan.gathering.afk.AFKTracker;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.TargetPlayerEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import plan.javax.inject.Inject;

public class SpongeAFKListener {
    static AFKTracker AFK_TRACKER;
    private final Map<UUID, Boolean> ignorePermissionInfo;
    private final ErrorLogger errorLogger;

    @Inject
    public SpongeAFKListener(PlanConfig config, ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
        this.ignorePermissionInfo = new HashMap<UUID, Boolean>();
        SpongeAFKListener.assignAFKTracker(config);
    }

    private static void assignAFKTracker(PlanConfig config) {
        if (AFK_TRACKER == null) {
            AFK_TRACKER = new AFKTracker(config);
        }
    }

    private void event(TargetPlayerEvent event) {
        try {
            this.performedAction(event.getTargetEntity());
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    @Listener(order=Order.POST)
    public void onMove(MoveEntityEvent event, @First Player player) {
        this.performedAction(player);
    }

    @Listener(order=Order.POST)
    public void onPlayerChat(MessageChannelEvent.Chat event, @First Player player) {
        this.performedAction(player);
    }

    private void performedAction(Player player) {
        UUID uuid = player.getUniqueId();
        long time = System.currentTimeMillis();
        boolean ignored = this.ignorePermissionInfo.computeIfAbsent(uuid, keyUUID -> player.hasPermission(Permissions.IGNORE_AFK.getPermission()));
        if (ignored) {
            AFK_TRACKER.hasIgnorePermission(uuid);
            this.ignorePermissionInfo.put(uuid, true);
            return;
        }
        this.ignorePermissionInfo.put(uuid, false);
        AFK_TRACKER.performedAction(uuid, time);
    }

    @Listener(order=Order.POST)
    public void onPlayerCommand(SendCommandEvent event, @First Player player) {
        this.performedAction(player);
        boolean isAfkCommand = event.getCommand().toLowerCase().startsWith("afk");
        if (isAfkCommand) {
            AFK_TRACKER.usedAfkCommand(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    @Listener(order=Order.POST)
    public void onSettingsChange(PlayerChangeClientSettingsEvent event) {
        this.event((TargetPlayerEvent)event);
    }

    @Listener(order=Order.POST)
    public void onLeave(ClientConnectionEvent.Disconnect event) {
        this.ignorePermissionInfo.remove(event.getTargetEntity().getUniqueId());
    }
}

