/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.sponge;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.gathering.cache.NicknameCache;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.NicknameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.Text;
import plan.javax.inject.Inject;

public class SpongeChatListener {
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final NicknameCache nicknameCache;
    private final ErrorLogger errorLogger;

    @Inject
    public SpongeChatListener(ServerInfo serverInfo, DBSystem dbSystem, NicknameCache nicknameCache, ErrorLogger errorLogger) {
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.nicknameCache = nicknameCache;
        this.errorLogger = errorLogger;
    }

    @Listener(order=Order.POST)
    public void onPlayerChat(MessageChannelEvent.Chat event, @First Player player) {
        if (event.isCancelled()) {
            return;
        }
        try {
            this.actOnChatEvent(player);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnChatEvent(@First Player player) {
        long time = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        String displayName = ((Text)player.getDisplayNameData().displayName().get()).toPlain();
        this.dbSystem.getDatabase().executeTransaction(new NicknameStoreTransaction(uuid, new Nickname(displayName, time, this.serverInfo.getServerUUID()), (playerUUID, name) -> this.nicknameCache.getDisplayName((UUID)playerUUID).map(name::equals).orElse(false)));
    }
}

