/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.sponge;

import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.WorldAliasSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.WorldNameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.living.humanoid.ChangeGameModeEvent;
import plan.javax.inject.Inject;

public class SpongeGMChangeListener {
    private final WorldAliasSettings worldAliasSettings;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public SpongeGMChangeListener(WorldAliasSettings worldAliasSettings, ServerInfo serverInfo, DBSystem dbSystem, ErrorLogger errorLogger) {
        this.worldAliasSettings = worldAliasSettings;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
    }

    @Listener(order=Order.POST)
    public void onGMChange(ChangeGameModeEvent.TargetPlayer event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            this.actOnGMChangeEvent(event);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related(event, event.getGameMode()).build());
        }
    }

    private void actOnGMChangeEvent(ChangeGameModeEvent.TargetPlayer event) {
        Player player = event.getTargetEntity();
        UUID uuid = player.getUniqueId();
        long time = System.currentTimeMillis();
        String gameMode = event.getGameMode().getName().toUpperCase();
        String worldName = player.getWorld().getName();
        this.dbSystem.getDatabase().executeTransaction(new WorldNameStoreTransaction(this.serverInfo.getServerUUID(), worldName));
        this.worldAliasSettings.addWorld(worldName);
        Optional<Session> cachedSession = SessionCache.getCachedSession(uuid);
        cachedSession.ifPresent(session -> session.changeState(worldName, gameMode, time));
    }
}

