/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.listeners.sponge;

import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.WorldAliasSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.WorldNameStoreTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.World;
import plan.javax.inject.Inject;

public class SpongeWorldChangeListener {
    private final WorldAliasSettings worldAliasSettings;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public SpongeWorldChangeListener(WorldAliasSettings worldAliasSettings, ServerInfo serverInfo, DBSystem dbSystem, ErrorLogger errorLogger) {
        this.worldAliasSettings = worldAliasSettings;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
    }

    @Listener(order=Order.POST)
    public void onWorldChange(MoveEntityEvent.Teleport event, @First Player player) {
        if (event.isCancelled()) {
            return;
        }
        try {
            this.actOnEvent(event, player);
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)event).build());
        }
    }

    private void actOnEvent(MoveEntityEvent.Teleport event, Player player) {
        long time = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        String worldName = ((World)event.getToTransform().getExtent()).getName();
        String gameMode = this.getGameMode(player);
        this.dbSystem.getDatabase().executeTransaction(new WorldNameStoreTransaction(this.serverInfo.getServerUUID(), worldName));
        this.worldAliasSettings.addWorld(worldName);
        Optional<Session> cachedSession = SessionCache.getCachedSession(uuid);
        cachedSession.ifPresent(session -> session.changeState(worldName, gameMode, time));
    }

    private String getGameMode(Player player) {
        Optional gameMode = player.getGameModeData().get(Keys.GAME_MODE);
        return gameMode.map(gm -> gm.getName().toUpperCase()).orElse("ADVENTURE");
    }
}

