/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.PingStoreTransaction;
import com.djrapitops.plan.utilities.java.Reflection;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class BukkitPingCounter
extends AbsRunnable
implements Listener {
    private static final boolean PING_METHOD_AVAILABLE = BukkitPingCounter.isPingMethodAvailable();
    private static final MethodHandle PING_FIELD;
    private static final MethodHandle GET_HANDLE_METHOD;
    private final Map<UUID, List<DateObj<Integer>>> playerHistory;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final RunnableFactory runnableFactory;

    @Inject
    public BukkitPingCounter(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, RunnableFactory runnableFactory) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.runnableFactory = runnableFactory;
        this.playerHistory = new HashMap<UUID, List<DateObj<Integer>>>();
    }

    private static boolean isPingMethodAvailable() {
        try {
            Class.forName("org.bukkit.entity.Player$Spigot").getDeclaredMethod("getPing", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException noSuchMethodEx) {
            return false;
        }
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, List<DateObj<Integer>>>> iterator = this.playerHistory.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, List<DateObj<Integer>>> entry = iterator.next();
            UUID uuid = entry.getKey();
            List<DateObj<Integer>> history = entry.getValue();
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                int ping = this.getPing(player);
                if (ping < -1 || (long)ping > TimeUnit.SECONDS.toMillis(8L)) continue;
                history.add(new DateObj<Integer>(time, ping));
                if (history.size() < 30) continue;
                this.dbSystem.getDatabase().executeTransaction(new PingStoreTransaction(uuid, this.serverInfo.getServerUUID(), new ArrayList<DateObj<Integer>>(history)));
                history.clear();
                continue;
            }
            iterator.remove();
        }
    }

    public void addPlayer(Player player) {
        this.playerHistory.put(player.getUniqueId(), new ArrayList());
    }

    public void removePlayer(Player player) {
        this.playerHistory.remove(player.getUniqueId());
    }

    private int getPing(Player player) {
        if (PING_METHOD_AVAILABLE) {
            return player.spigot().getPing();
        }
        return this.getReflectionPing(player);
    }

    private int getReflectionPing(Player player) {
        try {
            Object entityPlayer = GET_HANDLE_METHOD.invoke(player);
            return PING_FIELD.invoke(entityPlayer);
        }
        catch (Exception ex) {
            return -1;
        }
        catch (Throwable throwable) {
            throw (Error)throwable;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent joinEvent) {
        final Player player = joinEvent.getPlayer();
        Long pingDelay = this.config.get(TimeSettings.PING_PLAYER_LOGIN_DELAY);
        if (pingDelay >= TimeUnit.HOURS.toMillis(2L)) {
            return;
        }
        this.runnableFactory.create("Add Player to Ping list", new AbsRunnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    BukkitPingCounter.this.addPlayer(player);
                }
            }
        }).runTaskLater(TimeAmount.toTicks(pingDelay, TimeUnit.MILLISECONDS));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent quitEvent) {
        this.removePlayer(quitEvent.getPlayer());
    }

    public void clear() {
        this.playerHistory.clear();
    }

    static {
        MethodHandle localHandle = null;
        MethodHandle localPing = null;
        if (!PING_METHOD_AVAILABLE) {
            try {
                Class<?> craftPlayerClass = Reflection.getCraftBukkitClass("entity.CraftPlayer");
                Class<?> entityPlayer = Reflection.getMinecraftClass("EntityPlayer");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                Method getHandleMethod = craftPlayerClass.getDeclaredMethod("getHandle", new Class[0]);
                localHandle = lookup.unreflect(getHandleMethod);
                localPing = lookup.findGetter(entityPlayer, "ping", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveEx) {
                Logger.getGlobal().log(Level.WARNING, "Plan: Could not register Ping counter due to " + reflectiveEx);
            }
            catch (IllegalArgumentException e) {
                Logger.getGlobal().log(Level.WARNING, "Plan: No Ping method handle found - Ping will not be recorded.");
            }
        }
        GET_HANDLE_METHOD = localHandle;
        PING_FIELD = localPing;
    }
}

