/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plan.gathering.domain.builders.TPSBuilder;
import com.djrapitops.plan.gathering.timed.SystemUsageBuffer;
import com.djrapitops.plan.gathering.timed.TPSCounter;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.TPSStoreTransaction;
import com.djrapitops.plan.utilities.analysis.Average;
import com.djrapitops.plan.utilities.analysis.Maximum;
import com.djrapitops.plan.utilities.analysis.TimerAverage;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ProxyTPSCounter
extends TPSCounter {
    private final ServerSensor<Object> serverSensor;
    private final SystemUsageBuffer systemUsage;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Maximum.ForInteger playersOnline;
    private final Average cpu;
    private final TimerAverage ram;

    @Inject
    public ProxyTPSCounter(ServerSensor<Object> serverSensor, SystemUsageBuffer systemUsage, DBSystem dbSystem, ServerInfo serverInfo, PluginLogger logger, ErrorLogger errorLogger) {
        super(logger, errorLogger);
        this.serverSensor = serverSensor;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.systemUsage = systemUsage;
        this.playersOnline = new Maximum.ForInteger(0);
        this.cpu = new Average();
        this.ram = new TimerAverage();
    }

    @Override
    public void pulse() {
        long time = System.currentTimeMillis();
        boolean shouldSave = this.ram.add(time, this.systemUsage.getRam());
        this.playersOnline.add(this.serverSensor.getOnlinePlayerCount());
        this.cpu.add(this.systemUsage.getCpu());
        if (shouldSave) {
            this.save(time);
        }
    }

    private void save(long time) {
        long timeLastMinute = time - TimeUnit.MINUTES.toMillis(1L);
        int maxPlayers = this.playersOnline.getMaxAndReset();
        double averageCPU = this.cpu.getAverageAndReset();
        long averageRAM = (long)this.ram.getAverageAndReset(time);
        long freeDiskSpace = this.systemUsage.getFreeDiskSpace();
        this.dbSystem.getDatabase().executeTransaction(new TPSStoreTransaction(this.serverInfo.getServerUUID(), TPSBuilder.get().date(timeLastMinute).playersOnline(maxPlayers).usedCPU(averageCPU).usedMemory(averageRAM).freeDiskSpace(freeDiskSpace).toTPS()));
    }
}

