/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plan.gathering.domain.builders.TPSBuilder;
import com.djrapitops.plan.gathering.timed.SystemUsageBuffer;
import com.djrapitops.plan.gathering.timed.TPSCalculator;
import com.djrapitops.plan.gathering.timed.TPSCounter;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.TPSStoreTransaction;
import com.djrapitops.plan.utilities.analysis.Average;
import com.djrapitops.plan.utilities.analysis.Maximum;
import com.djrapitops.plan.utilities.analysis.TimerAverage;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerTPSCounter<W>
extends TPSCounter {
    private final boolean noDirectTPS;
    private final ServerSensor<W> serverSensor;
    private final SystemUsageBuffer systemUsage;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private TPSCalculator indirectTPS;
    private TimerAverage directTPS;
    private final Maximum.ForInteger playersOnline;
    private final Average cpu;
    private final Average ram;

    @Inject
    public ServerTPSCounter(ServerSensor<W> serverSensor, SystemUsageBuffer systemUsage, DBSystem dbSystem, ServerInfo serverInfo, PluginLogger logger, ErrorLogger errorLogger) {
        super(logger, errorLogger);
        this.noDirectTPS = !serverSensor.supportsDirectTPS();
        this.serverSensor = serverSensor;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.systemUsage = systemUsage;
        if (this.noDirectTPS) {
            this.indirectTPS = new TPSCalculator();
        } else {
            this.directTPS = new TimerAverage();
        }
        this.playersOnline = new Maximum.ForInteger(0);
        this.cpu = new Average();
        this.ram = new Average();
    }

    @Override
    public void pulse() {
        long time = System.currentTimeMillis();
        Optional<Double> result = this.pulseTPS(time);
        this.playersOnline.add(this.serverSensor.getOnlinePlayerCount());
        this.cpu.add(this.systemUsage.getCpu());
        this.ram.add(this.systemUsage.getRam());
        result.ifPresent(tps -> this.save((double)tps, time));
    }

    private void save(double averageTPS, long time) {
        long timeLastMinute = time - TimeUnit.MINUTES.toMillis(1L);
        int maxPlayers = this.playersOnline.getMaxAndReset();
        double averageCPU = this.cpu.getAverageAndReset();
        long averageRAM = (long)this.ram.getAverageAndReset();
        int entityCount = 0;
        int chunkCount = 0;
        for (W world : this.serverSensor.getWorlds()) {
            entityCount += this.serverSensor.getEntityCount(world);
            chunkCount += this.serverSensor.getChunkCount(world);
        }
        long freeDiskSpace = this.systemUsage.getFreeDiskSpace();
        this.dbSystem.getDatabase().executeTransaction(new TPSStoreTransaction(this.serverInfo.getServerUUID(), TPSBuilder.get().date(timeLastMinute).tps(averageTPS).playersOnline(maxPlayers).usedCPU(averageCPU).usedMemory(averageRAM).entities(entityCount).chunksLoaded(chunkCount).freeDiskSpace(freeDiskSpace).toTPS()));
    }

    public Optional<Double> pulseTPS(long time) {
        if (this.noDirectTPS) {
            return this.indirectTPS.pulse(time);
        }
        if (this.directTPS.add(time, this.serverSensor.getTPS())) {
            return Optional.of(this.directTPS.getAverageAndReset(time));
        }
        return Optional.empty();
    }
}

