/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.events.PingStoreTransaction;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import plan.javax.inject.Inject;

public class SpongePingCounter
extends AbsRunnable {
    private final Map<UUID, List<DateObj<Integer>>> playerHistory;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final RunnableFactory runnableFactory;

    @Inject
    public SpongePingCounter(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, RunnableFactory runnableFactory) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.runnableFactory = runnableFactory;
        this.playerHistory = new HashMap<UUID, List<DateObj<Integer>>>();
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, List<DateObj<Integer>>>> iterator = this.playerHistory.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, List<DateObj<Integer>>> entry = iterator.next();
            UUID uuid = entry.getKey();
            List<DateObj<Integer>> history = entry.getValue();
            Optional player = Sponge.getServer().getPlayer(uuid);
            if (player.isPresent()) {
                int ping = this.getPing((Player)player.get());
                if (ping < -1 || (long)ping > TimeUnit.SECONDS.toMillis(8L)) continue;
                history.add(new DateObj<Integer>(time, ping));
                if (history.size() < 30) continue;
                this.dbSystem.getDatabase().executeTransaction(new PingStoreTransaction(uuid, this.serverInfo.getServerUUID(), new ArrayList<DateObj<Integer>>(history)));
                history.clear();
                continue;
            }
            iterator.remove();
        }
    }

    public void addPlayer(Player player) {
        this.playerHistory.put(player.getUniqueId(), new ArrayList());
    }

    public void removePlayer(Player player) {
        this.playerHistory.remove(player.getUniqueId());
    }

    private int getPing(Player player) {
        return player.getConnection().getLatency();
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join joinEvent) {
        final Player player = joinEvent.getTargetEntity();
        Long pingDelay = this.config.get(TimeSettings.PING_PLAYER_LOGIN_DELAY);
        if (pingDelay >= TimeUnit.HOURS.toMillis(2L)) {
            return;
        }
        this.runnableFactory.create("Add Player to Ping list", new AbsRunnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    SpongePingCounter.this.addPlayer(player);
                }
            }
        }).runTaskLater(TimeAmount.toTicks(pingDelay, TimeUnit.MILLISECONDS));
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect quitEvent) {
        this.removePlayer(quitEvent.getTargetEntity());
    }

    public void clear() {
        this.playerHistory.clear();
    }
}

