/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.gathering.SystemUsage;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SystemUsageBuffer {
    private double cpu = -1.0;
    private long ram = -1L;
    private long freeDiskSpace = -1L;

    @Inject
    public SystemUsageBuffer() {
        this.warmUp();
    }

    public void warmUp() {
        SystemUsage.getAverageSystemLoad();
        SystemUsage.getUsedMemory();
        SystemUsage.getFreeDiskSpace();
    }

    public double getCpu() {
        return this.cpu;
    }

    public long getRam() {
        return this.ram;
    }

    public long getFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    @Singleton
    public static class DiskTask
    extends AbsRunnable {
        private final PlanConfig config;
        private final SystemUsageBuffer buffer;
        private final PluginLogger logger;
        private final ErrorLogger errorLogger;
        private Boolean gatherDisk = null;
        private boolean diskErrored = false;

        @Inject
        public DiskTask(PlanConfig config, SystemUsageBuffer buffer, PluginLogger logger, ErrorLogger errorLogger) {
            this.config = config;
            this.buffer = buffer;
            this.logger = logger;
            this.errorLogger = errorLogger;
        }

        @Override
        public void run() {
            if (this.gatherDisk == null) {
                this.gatherDisk = this.config.get(DataGatheringSettings.DISK_SPACE);
            }
            if (!this.gatherDisk.booleanValue()) {
                return;
            }
            try {
                this.buffer.freeDiskSpace = SystemUsage.getFreeDiskSpace();
            }
            catch (SecurityException noPermission) {
                if (!this.diskErrored) {
                    this.errorLogger.log(L.WARN, noPermission, ErrorContext.builder().whatToDo("Resolve " + noPermission.getMessage() + " via OS or JVM permissions").build());
                }
                this.diskErrored = true;
            }
            catch (Exception e) {
                this.logger.error("Free Disk sampling task had to be stopped due to error: " + e.toString());
                this.cancel();
            }
        }
    }

    @Singleton
    public static class RamAndCpuTask
    extends AbsRunnable {
        private final SystemUsageBuffer buffer;
        private final PluginLogger logger;

        @Inject
        public RamAndCpuTask(SystemUsageBuffer buffer, PluginLogger logger) {
            this.buffer = buffer;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                this.buffer.cpu = SystemUsage.getAverageSystemLoad();
                this.buffer.ram = SystemUsage.getUsedMemory();
            }
            catch (Exception e) {
                this.logger.error("RAM & CPU sampling task had to be stopped due to error: " + e.toString());
                this.cancel();
            }
        }
    }
}

