/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering.timed;

import com.djrapitops.plan.utilities.analysis.TimerAverage;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TPSCalculator {
    public static final long SECOND_NS = TimeUnit.SECONDS.toNanos(1L);
    private long maxBeforeZeroTPS = SECOND_NS * 20L;
    private long lastPulse = -1L;
    private TimerAverage averager = new TimerAverage();

    public Optional<Double> pulse(long time) {
        boolean firstRun = this.lastPulse < 0L;
        long currentPulse = System.nanoTime();
        long difference = currentPulse - this.lastPulse;
        this.lastPulse = currentPulse;
        if (firstRun) {
            return Optional.empty();
        }
        if (difference < SECOND_NS) {
            difference = SECOND_NS;
        }
        while (difference > this.maxBeforeZeroTPS) {
            this.averager.add(time, 0.0);
            difference -= this.maxBeforeZeroTPS;
        }
        double tps = (double)this.maxBeforeZeroTPS * 1.0 / (double)difference;
        if (this.averager.add(time, tps)) {
            return Optional.of(this.averager.getAverageAndReset(time));
        }
        return Optional.empty();
    }
}

