/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.delivery.web.resolver.exception.BadRequestException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class Identifiers {
    protected final DBSystem dbSystem;
    private final UUIDUtility uuidUtility;

    @Inject
    public Identifiers(DBSystem dbSystem, UUIDUtility uuidUtility) {
        this.dbSystem = dbSystem;
        this.uuidUtility = uuidUtility;
    }

    public UUID getServerUUID(Request request) {
        String serverIndentifier = request.getQuery().get("server").orElseThrow(() -> new BadRequestException("'server' parameter was not defined."));
        Optional<UUID> parsed = UUIDUtility.parseFromString(serverIndentifier);
        return parsed.orElseGet(() -> this.getServerUUIDFromName(serverIndentifier));
    }

    private UUID getServerUUIDFromName(String serverName) {
        return this.dbSystem.getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverName)).map(Server::getUuid).orElseThrow(() -> new BadRequestException("Given 'server' was not found in the database: '" + serverName + "'"));
    }

    public UUID getPlayerUUID(Request request) {
        String playerIdentifier = request.getQuery().get("player").orElseThrow(() -> new BadRequestException("'player' parameter was not defined.")).trim();
        Optional<UUID> parsed = UUIDUtility.parseFromString(playerIdentifier);
        return parsed.orElseGet(() -> this.getPlayerUUIDFromName(playerIdentifier));
    }

    private UUID getPlayerUUIDFromName(String playerName) {
        return this.dbSystem.getDatabase().query(UserIdentifierQueries.fetchPlayerUUIDOf(playerName)).orElseThrow(() -> new BadRequestException("Given 'player' was not found in the database: '" + playerName + "'"));
    }

    public UUID getPlayerUUID(String name) {
        return this.uuidUtility.getUUIDOf(name);
    }
}

